/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzAPIClient;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzClient;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzHostedConfigBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzHostedDataBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzRemoteException;
import com.atlassian.jira.plugins.importer.imports.fogbugz.web.FogBugzHostedSetupPage;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterFieldMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterLinksPage;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterValueMappingsPage;
import com.atlassian.jira.plugins.importer.web.RemoteSiteImporterSetupPage;
import com.atlassian.jira.plugins.importer.web.RemoteSiteValidator;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;

public class FogBugzHostedImporterController
extends AbstractImporterController {
    private final ConfigFileHandler configFileHandler;

    public FogBugzHostedImporterController(JiraDataImporter fogbugzImporter, ConfigFileHandler configFileHandler) {
        super(fogbugzImporter, "issue.importer.jira.fogbugz.hosted.import.bean", "FogBugzHosted");
        this.configFileHandler = configFileHandler;
    }

    @Override
    public boolean createImportProcessBean(AbstractSetupPage setupPage) {
        FogBugzHostedSetupPage fogBugzHostedSetupPage = (FogBugzHostedSetupPage)setupPage;
        Optional<FogBugzAPIClient> client = this.validateRemoteSiteConnection(fogBugzHostedSetupPage);
        if (!client.isPresent()) {
            return false;
        }
        if (fogBugzHostedSetupPage.invalidInput()) {
            return false;
        }
        SiteConfiguration siteConfiguration = new SiteConfiguration(fogBugzHostedSetupPage.getSiteUrl(), fogBugzHostedSetupPage.getSiteCredentials(), fogBugzHostedSetupPage.getSiteUsername(), fogBugzHostedSetupPage.getSitePassword());
        ImportProcessBean importProcessBean = new ImportProcessBean();
        importProcessBean.setUrlBean(siteConfiguration);
        FogBugzHostedConfigBean configBean = new FogBugzHostedConfigBean(new FogBugzClient((FogBugzAPIClient)client.get()));
        if (!this.configFileHandler.populateFromConfigFile(fogBugzHostedSetupPage, configBean)) {
            return false;
        }
        importProcessBean.setConfigBean(configBean);
        this.storeImportProcessBeanInSession(importProcessBean);
        return true;
    }

    @Override
    public ImportDataBean createDataBean() {
        ImportProcessBean importProcessBean = this.getImportProcessBeanFromSession();
        return new FogBugzHostedDataBean((FogBugzHostedConfigBean)importProcessBean.getConfigBean());
    }

    @Override
    public List<String> getSteps() {
        return Lists.newArrayList((Object[])new String[]{FogBugzHostedSetupPage.class.getSimpleName(), ImporterProjectMappingsPage.class.getSimpleName(), ImporterFieldMappingsPage.class.getSimpleName(), ImporterValueMappingsPage.class.getSimpleName(), ImporterLinksPage.class.getSimpleName()});
    }

    @Override
    public List<String> getStepNameKeys() {
        return Lists.newArrayList((Object[])new String[]{"jira-importer-plugin.wizard.step.ImporterSetupPage", "jira-importer-plugin.wizard.step.ImporterProjectMappingsPage", "jira-importer-plugin.wizard.step.ImporterFieldMappingsPage", "jira-importer-plugin.wizard.step.ImporterValueMappingsPage", "jira-importer-plugin.wizard.step.ImporterLinksPage"});
    }

    private Optional<FogBugzAPIClient> validateRemoteSiteConnection(RemoteSiteImporterSetupPage importerSetupPage) {
        if (new RemoteSiteValidator().validateConnection(importerSetupPage)) {
            try {
                FogBugzAPIClient client = new FogBugzAPIClient(importerSetupPage.getSiteUrl(), importerSetupPage.getSiteUsername(), importerSetupPage.getSitePassword());
                client.login();
                client.logout();
                return Optional.of((Object)client);
            }
            catch (FogBugzRemoteException e) {
                importerSetupPage.addErrorMessage("Cannot login to FogBugz site: " + e.getMessage());
            }
        }
        return Optional.absent();
    }
}

