/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.AreaParser;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FixForParser;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzAPIClient;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzRemoteException;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.PeopleParser;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.ProjectParser;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.StatusParser;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ConsoleImportLogger;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalRemoteException;
import com.atlassian.jira.util.AttachmentUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;

public class FogBugzClient {
    private final FogBugzAPIClient apiClient;

    public FogBugzClient(FogBugzAPIClient fogBugzAPIClient) {
        this.apiClient = fogBugzAPIClient;
    }

    public Collection<String> getAllProjectNames() throws FogBugzRemoteException {
        Collection<ExternalProject> allProjects = this.getAllProjects(ConsoleImportLogger.INSTANCE);
        return Collections2.transform(allProjects, (Function)ExternalProject.NAME_FUNCTION);
    }

    public Collection<ExternalProject> getAllProjects(ImportLogger log) throws FogBugzRemoteException {
        Element projects = this.apiClient.getWithToken(UriBuilder.fromUri((URI)this.apiClient.getApiAdress()).queryParam("cmd", new Object[]{"listProjects"}));
        return new ProjectParser().getProjects(projects);
    }

    public Collection<ExternalVersion> getFixFors(ExternalProject project, ImportLogger log) throws FogBugzRemoteException {
        UriBuilder uri = UriBuilder.fromUri((URI)this.apiClient.getApiAdress()).queryParam("cmd", new Object[]{"listFixFors"}).queryParam("ixProject", new Object[]{project.getId()});
        Element xmlResult = this.apiClient.getWithToken(uri);
        return new FixForParser().getFixFors(xmlResult);
    }

    public Collection<ExternalComponent> getAreas(ExternalProject project, ImportLogger log) throws FogBugzRemoteException {
        Element xmlResult = this.apiClient.getWithToken(UriBuilder.fromUri((URI)this.apiClient.getApiAdress()).queryParam("cmd", new Object[]{"listAreas"}).queryParam("ixProject", new Object[]{project.getId()}));
        return new AreaParser().getAreas(xmlResult);
    }

    public Collection<ExternalUser> getAllUsers(ImportLogger importLogger) throws FogBugzRemoteException {
        Element memberships = this.apiClient.getWithToken(UriBuilder.fromUri((URI)this.apiClient.getApiAdress()).queryParam("cmd", new Object[]{"listPeople"}).queryParam("fIncludeDeleted", new Object[]{1}).queryParam("fIncludeActive", new Object[]{1}).queryParam("fIncludeNormal", new Object[]{1}));
        return new PeopleParser().getPeople(memberships);
    }

    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        List<ExternalAttachment> externalAttachments = externalIssue.getAttachments();
        ArrayList result = Lists.newArrayListWithCapacity((int)externalAttachments.size());
        for (ExternalAttachment attachment : externalAttachments) {
            PivotalExternalAttachment pivotalAttachment = (PivotalExternalAttachment)attachment;
            try {
                File file = File.createTempFile("fogBugzAttachment-", ".tmp", this.getTempDir());
                this.download(pivotalAttachment.getUrl(), file);
                pivotalAttachment.setAttachment(file);
                result.add(pivotalAttachment);
            }
            catch (IOException e) {
                log.fail(e, "Error retrieving attachment", new Object[0]);
            }
            catch (URISyntaxException e) {
                log.fail(e, "Error retrieving attachment", new Object[0]);
            }
        }
        return result;
    }

    protected File getTempDir() {
        return AttachmentUtils.getTemporaryAttachmentDirectory();
    }

    public long getTotalCases(Set<ExternalProject> selectedProjects, ImportLogger log) throws FogBugzRemoteException {
        long count = 0L;
        long lastCaseId = 0L;
        long lastCount = 0L;
        String projectsQuery = Joiner.on((String)" OR ").join(Iterables.transform(selectedProjects, (Function)new Function<ExternalProject, Object>(){

            public Object apply(ExternalProject input) {
                return "project:=" + input.getId();
            }
        }));
        do {
            List<Element> elements;
            if (!(elements = this.searchForCases(String.format("%s orderby:\"ixBug\" ixBug:\"%d..\"", projectsQuery, lastCaseId + 1L), "", 2000)).isEmpty()) {
                Element lastElement = elements.get(elements.size() - 1);
                try {
                    lastCaseId = Long.parseLong(lastElement.getAttribute("ixBug").getValue());
                }
                catch (NumberFormatException e) {
                    log.warn("Malformed XML while trying to get case count number", new Object[0]);
                    return 0L;
                }
            }
            lastCount = elements.size();
            count += lastCount;
        } while (lastCount > 0L);
        return count;
    }

    public List<Element> searchForCases(String q, String cols, int max) throws FogBugzRemoteException {
        UriBuilder uri = UriBuilder.fromUri((URI)this.apiClient.getApiAdress()).queryParam("cmd", new Object[]{"search"}).queryParam("q", new Object[]{q.replaceAll(" ", "%20")}).queryParam("cols", new Object[]{StringUtils.isNotEmpty((String)cols) ? cols : "ixBug"}).queryParam("max", new Object[]{max});
        Element response = this.apiClient.getWithToken(uri);
        return XmlUtil.getChildren(response.getChild("cases"), "case");
    }

    public InputStream searchForCase(String q, String cols) throws FogBugzRemoteException {
        UriBuilder uri = UriBuilder.fromUri((URI)this.apiClient.getApiAdress()).queryParam("cmd", new Object[]{"search"}).queryParam("q", new Object[]{q.replaceAll(" ", "%20")}).queryParam("cols", new Object[]{StringUtils.isNotEmpty((String)cols) ? cols : "ixBug"}).queryParam("max", new Object[]{1});
        return this.apiClient.getWithToken0(uri);
    }

    private void download(String url, File destination) throws IOException, URISyntaxException {
        FileOutputStream outputStream = null;
        String fogBugzBaseUrl = this.apiClient.getBaseURLwithSlash();
        InputStream inputStream = this.apiClient.getWithToken0(UriBuilder.fromUri((URI)new URI(fogBugzBaseUrl + url)));
        try {
            outputStream = FileUtils.openOutputStream((File)destination);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new PivotalRemoteException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public Set<String> getStatuses() throws FogBugzRemoteException {
        UriBuilder uri = UriBuilder.fromUri((URI)this.apiClient.getApiAdress()).queryParam("cmd", new Object[]{"listStatuses"});
        return new StatusParser().getStatuses(this.apiClient.getWithToken(uri));
    }

    public void logout() {
        this.apiClient.logout();
    }

    public URI getRootUri() {
        return this.apiClient.getRootUri();
    }

    public FogBugzAPIClient getApiClient() {
        return this.apiClient;
    }
}

