/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.imports.HttpDownloader;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzParsingException;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzRemoteException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FogBugzAPIClient {
    public static final String API_PAGE = "/api.asp";
    private String token;
    private HttpContext httpContext;
    private final URI rootUri;
    private final String email;
    private final String password;
    private URI apiUri;

    public URI getApiAdress() {
        return this.apiUri;
    }

    public URI getRootUri() {
        return this.rootUri;
    }

    public FogBugzAPIClient(String rootUri, String email, String password) {
        this(FogBugzAPIClient.toUri(rootUri), email, password);
    }

    public FogBugzAPIClient(URI rootUri, String email, String password) {
        this.email = email;
        this.password = password;
        this.rootUri = rootUri;
    }

    private static URI toUri(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getApiUri() throws FogBugzRemoteException {
        if (this.rootUri.getHost().endsWith("fogbugz.com")) {
            return UriBuilder.fromUri((URI)this.rootUri).path(API_PAGE).build(new Object[0]);
        }
        return this.getApiPathInOlderFogbugz();
    }

    public String getBaseURLwithSlash() {
        return this.apiUri.toString().replace(API_PAGE, "") + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI getApiPathInOlderFogbugz() throws FogBugzRemoteException {
        URI fbApiUri = UriBuilder.fromUri((URI)this.rootUri).path("/fogbugz/api.asp").build(new Object[0]);
        HttpHead head = new HttpHead(fbApiUri);
        head.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
        try {
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)head);
            try {
                if (response.getStatusLine().getStatusCode() == 200) {
                    URI uRI = fbApiUri;
                    return uRI;
                }
                URI uRI = UriBuilder.fromUri((URI)this.rootUri).path(API_PAGE).build(new Object[0]);
                return uRI;
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            throw new FogBugzRemoteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login() throws FogBugzRemoteException {
        this.token = null;
        this.httpContext = new BasicHttpContext();
        this.apiUri = this.getApiUri();
        HttpPost post = new HttpPost(UriBuilder.fromUri((URI)this.apiUri).queryParam("cmd", new Object[]{"logon"}).build(new Object[0]));
        try {
            URI targetUri;
            String targetHost;
            Header location;
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity((List)Lists.newArrayList((Object[])new NameValuePair[]{new BasicNameValuePair("email", this.email), new BasicNameValuePair("password", this.password)}));
            post.setEntity((HttpEntity)entity);
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)post, this.httpContext);
            if (response.getStatusLine().getStatusCode() == 302 && (location = response.getFirstHeader("Location")) != null && location.getValue() != null && (targetHost = (targetUri = URI.create(location.getValue())).getHost()).equals(this.apiUri.getHost()) && !targetUri.getScheme().equals(this.apiUri.getScheme())) {
                throw new FogBugzRemoteException("The server requested redirection. Please consider using \"" + targetUri.getScheme() + "\" instead of \"" + this.apiUri.getScheme() + "\".");
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new FogBugzRemoteException("HTTP Error code " + response + " returned by the server");
            }
            InputStream is = response.getEntity().getContent();
            if (is == null) {
                throw new FogBugzRemoteException("Connection failed. Empty response returned by the server");
            }
            try {
                SAXBuilder builder = XmlUtil.getSAXBuilder();
                Document document = builder.build(is);
                this.token = document.getRootElement().getChildText("token");
                if (this.token == null) {
                    throw new FogBugzRemoteException("Login failed. Authentication token has not been served by the server");
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (FogBugzRemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FogBugzRemoteException(e);
        }
    }

    public void logout() {
        try {
            this.getWithToken(UriBuilder.fromUri((URI)this.apiUri).queryParam("cmd", new Object[]{"logoff"}));
        }
        catch (FogBugzRemoteException fogBugzRemoteException) {
            // empty catch block
        }
        this.token = null;
        this.httpContext = null;
    }

    public InputStream getWithToken0(UriBuilder url) throws FogBugzRemoteException {
        this.ensureLoggedInToWeb();
        HttpGet getMethod = new HttpGet(url.queryParam("token", new Object[]{this.token}).build(new Object[0]));
        try {
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)getMethod, this.httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new FogBugzRemoteException("HTTP Error code " + response + " returned by the server");
            }
            if (response.getEntity().getContentLength() == 0L) {
                throw new FogBugzRemoteException("Server returned an empty response");
            }
            InputStream is = response.getEntity().getContent();
            if (is == null) {
                throw new FogBugzRemoteException("Connection failed. Empty response returned by the server");
            }
            return is;
        }
        catch (FogBugzRemoteException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FogBugzRemoteException(e);
        }
    }

    protected void ensureLoggedInToWeb() throws FogBugzRemoteException {
        if (this.token == null) {
            this.login();
        }
    }

    public Element getWithToken(UriBuilder uri) throws FogBugzRemoteException {
        this.ensureLoggedInToWeb();
        InputStream is = null;
        try {
            is = this.getWithToken0(uri);
            if (is == null) {
                throw new FogBugzRemoteException("Login failed. Empty response returned by the server");
            }
            SAXBuilder builder = XmlUtil.getSAXBuilder();
            Document document = builder.build(is);
            Element element = document.getRootElement();
            return element;
        }
        catch (FogBugzRemoteException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FogBugzRemoteException(e);
        }
        catch (JDOMException e) {
            throw new FogBugzParsingException(e);
        }
        catch (IllegalDataException e) {
            throw new FogBugzParsingException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private HttpClient getHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpDownloader.setDefaultProxy(client);
        return client;
    }
}

