/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.external.MimeUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.fogbugz.config.ResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.fogbugz.config.StatusValueMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalExternalAttachment;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class CaseParser
implements Function<Element, ExternalIssue> {
    private static final int SECONDS_IN_HOUR = 3600;
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ssz";
    private final ImportLogger log;

    public CaseParser(ImportLogger log) {
        this.log = log;
    }

    public ExternalIssue apply(Element element) {
        String fixFor;
        String version;
        String area;
        String summary = element.getChildText("sTitle");
        String oldId = element.getChildText("ixBug");
        ExternalIssue externalIssue = new ExternalIssue();
        externalIssue.setExternalId(oldId);
        externalIssue.setSummary(StringUtils.isEmpty((String)summary) ? "<Summary couldn't be downloaded>" : summary);
        externalIssue.setIssueType(element.getChildText("sCategory"));
        String ixPriority = element.getChildText("ixPriority");
        String sPriority = element.getChildText("sPriority");
        if (StringUtils.isNotEmpty((String)ixPriority)) {
            externalIssue.setPriority(ixPriority + "-" + sPriority);
        }
        if (StringUtils.isNotBlank((String)(area = element.getChildText("sArea")))) {
            externalIssue.setComponents(Collections.singleton(area));
        }
        if (StringUtils.isNotBlank((String)(version = element.getChildText("sVersion")))) {
            externalIssue.setAffectedVersions(Collections.singleton(version));
        }
        if (StringUtils.isNotBlank((String)(fixFor = element.getChildText("sFixFor")))) {
            externalIssue.setFixedVersions(Collections.singleton(fixFor));
        }
        externalIssue.setReporter(element.getChildText("ixPersonOpenedBy"));
        externalIssue.setAssignee(element.getChildText("ixPersonAssignedTo"));
        String dtOpened = element.getChildText("dtOpened");
        String dtDue = element.getChildText("dtDue");
        if (StringUtils.isNotEmpty((String)dtOpened)) {
            externalIssue.setCreated(CaseParser.parseDateTime(dtOpened));
        }
        if (StringUtils.isNotEmpty((String)dtDue)) {
            externalIssue.setDuedate(CaseParser.parseDateTime(dtDue));
        }
        externalIssue.setLabels(this.parseTags(element.getChild("tags")));
        DateTime closed = StringUtils.isNotEmpty((String)element.getChildText("dtClosed")) ? CaseParser.parseDateTime(element.getChildText("dtClosed")) : null;
        DateTime resolved = StringUtils.isNotEmpty((String)element.getChildText("dtResolved")) ? CaseParser.parseDateTime(element.getChildText("dtResolved")) : null;
        externalIssue.setResolutionDate(resolved);
        if (closed != null && resolved == null) {
            externalIssue.setUpdated(closed);
        } else if (closed == null && resolved != null) {
            externalIssue.setUpdated(resolved);
        } else if (closed != null) {
            if (closed.isAfter((ReadableInstant)resolved)) {
                externalIssue.setUpdated(closed);
            } else {
                externalIssue.setUpdated(resolved);
            }
        }
        String fogBugzStatus = element.getChildText("sStatus");
        String cleanedResolution = ResolutionValueMapper.getCleanedResolution(fogBugzStatus);
        String cleanedStatus = StatusValueMapper.getCleanedStatus(fogBugzStatus);
        externalIssue.setStatus(Boolean.valueOf(element.getChildText("fOpen")) != false ? cleanedStatus : "Closed");
        if (cleanedResolution != null) {
            externalIssue.setResolution(cleanedResolution);
        }
        long originalEstimate = element.getChildText("hrsOrigEst") != null ? (long)(Double.valueOf(element.getChildText("hrsOrigEst")) * 3600.0) : 0L;
        long timeSpent = element.getChildText("hrsElapsed") != null ? (long)(Double.valueOf(element.getChildText("hrsElapsed")) * 3600.0) : 0L;
        double hrsCurrEst = element.getChildText("hrsCurrEst") != null ? Double.valueOf(element.getChildText("hrsCurrEst")) : 0.0;
        long currentEstimate = (long)(hrsCurrEst * 3600.0) - timeSpent;
        externalIssue.setOriginalEstimate(originalEstimate > 0L ? Long.valueOf(originalEstimate) : null);
        externalIssue.setEstimate(currentEstimate > 0L ? Long.valueOf(currentEstimate) : null);
        externalIssue.setTimeSpent(timeSpent > 0L ? Long.valueOf(timeSpent) : null);
        Element eventsElement = element.getChild("events");
        List<Element> events = XmlUtil.getChildren(eventsElement, "event");
        Optional<String> firstEventDescription = this.getDescription(events);
        ArrayList commentEvents = Lists.newArrayList(events);
        if (firstEventDescription.isPresent()) {
            externalIssue.setDescription((String)firstEventDescription.get());
            commentEvents.remove(0);
        }
        externalIssue.setComments(this.parseComments(commentEvents));
        externalIssue.setAttachments(this.parseAttachments(events));
        ArrayList customFields = Lists.newArrayList();
        if (StringUtils.isNotEmpty((String)element.getChildText("sCustomerEmail"))) {
            customFields.add(this.createCustomFieldTextValue("Customer Email", element.getChildText("sCustomerEmail")));
        }
        if (StringUtils.isNotEmpty((String)element.getChildText("sComputer"))) {
            customFields.add(this.createCustomFieldTextValue("Computer", element.getChildText("sComputer")));
        }
        externalIssue.setExternalCustomFieldValues(customFields);
        return externalIssue;
    }

    private ExternalCustomFieldValue createCustomFieldTextValue(String fieldName, String fieldValue) {
        return new ExternalCustomFieldValue(fieldName, "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher", fieldValue);
    }

    private Optional<String> getDescription(List<Element> events) {
        if (events.isEmpty()) {
            return Optional.absent();
        }
        Element firstEvent = events.get(0);
        Optional<String> description = this.getTextFromSElement(firstEvent);
        if (description.isPresent()) {
            return Optional.of((Object)description.get());
        }
        return Optional.absent();
    }

    protected Set<String> parseTags(@Nullable Element tags) {
        HashSet result = Sets.newHashSet();
        if (tags != null) {
            for (Object tag : tags.getChildren("tag")) {
                String cleanLabel = LabelParser.getCleanLabel((String)((Element)tag).getText());
                if (!StringUtils.isNotBlank((String)cleanLabel)) continue;
                result.add(cleanLabel);
            }
        }
        return result;
    }

    private List<ExternalComment> parseComments(List<Element> events) {
        Collection comments = Collections2.filter(events, (Predicate)new Predicate<Element>(){

            public boolean apply(@Nullable Element input) {
                return input != null && StringUtils.isNotBlank((String)input.getChildText("s"));
            }
        });
        return Lists.newArrayList((Iterable)Collections2.transform((Collection)comments, (Function)new Function<Element, ExternalComment>(){

            public ExternalComment apply(Element element) {
                String commenter = element.getChildText("ixPerson");
                Optional commentBody = CaseParser.this.getTextFromSElement(element);
                if (commentBody.isPresent()) {
                    return new ExternalComment((String)commentBody.get(), commenter, CaseParser.parseDateTime(element.getChildText("dt")));
                }
                return null;
            }
        }));
    }

    private Optional<String> getTextFromSElement(Element element) {
        String comment = element.getChildText("s");
        if (StringUtils.isNotBlank((String)comment)) {
            String body = Boolean.valueOf(element.getChildText("fEmail")) == false ? StringUtils.trimToEmpty((String)comment) : MimeUtils.getTextDataFromMimeMessage(comment);
            return Optional.of((Object)body);
        }
        return Optional.absent();
    }

    @VisibleForTesting
    List<ExternalAttachment> parseAttachments(List<Element> events) {
        ArrayList attachments = Lists.newArrayList();
        for (Element event : events) {
            for (Element rgAttachments : XmlUtil.getChildren(event, "rgAttachments")) {
                for (Element attachment : XmlUtil.getChildren(rgAttachments, "attachment")) {
                    String filename = attachment.getChildText("sFileName");
                    String url = attachment.getChildTextNormalize("sURL").replace("&amp;", "&");
                    DateTime uploadedAt = CaseParser.parseDateTime(event.getChildText("dt"));
                    PivotalExternalAttachment pae = new PivotalExternalAttachment(filename, url, uploadedAt.toDate());
                    pae.setAttacher(event.getChildText("ixPerson"));
                    attachments.add(pae);
                }
            }
        }
        return attachments;
    }

    static DateTime parseDateTime(String str) {
        ParsePosition parsePosition;
        SimpleDateFormat simpleDateFormat;
        Date date;
        if (str.endsWith("Z")) {
            str = StringUtils.removeEnd((String)str, (String)"Z") + "-0000";
        }
        if ((date = (simpleDateFormat = new SimpleDateFormat(DATE_TIME_PATTERN, Locale.ENGLISH)).parse(str, parsePosition = new ParsePosition(0))) == null || parsePosition.getIndex() != str.length()) {
            throw new IllegalArgumentException("Cannot parse [" + str + "] to date/time using pattern [" + DATE_TIME_PATTERN + "]");
        }
        return new DateTime((Object)date);
    }
}

