/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.CaseParser;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzClient;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzHostedConfigBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzParsingException;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzRemoteException;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.LinkParser;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.util.iterator.ItemFactory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;

public class CaseFactory
implements ItemFactory<ExternalIssue> {
    private static final int CASE_CHUNK_SIZE = 50;
    public static final String ALL_COLUMNS = "ixBug,ixBugParent,tags,fOpen,sTitle,sArea,sComputer,ixPersonAssignedTo,ixPersonOpenedBy,sStatus,ixPriority,sPriority,sFixFor,sVersion,sCustomerEmail,dtOpened,dtClosed,dtResolved,hrsOrigEst,hrsElapsed,hrsCurrEst,sCategory,events";
    public static final String COLUMNS_FOR_PARSING_ERROR = "ixBug,ixBugParent,sArea,ixPersonAssignedTo,ixPersonOpenedBy,sStatus,sFixFor,sCustomerEmail,dtOpened,dtClosed,dtResolved,hrsOrigEst,hrsElapsed,hrsCurrEst";
    private final FogBugzClient fogBugzClient;
    private final String projectId;
    private final ImportLogger log;
    private final CaseParser caseParser;
    private final Map<String, ExternalUser> userIdToExternalUser;
    private final FogBugzHostedConfigBean configBean;
    private final List<ExternalLink> links = Lists.newArrayList();
    private long lastCaseId = 0L;
    private final Function<ExternalIssue, ExternalIssue> ADD_EXTERNAL_ISSUE_URL = new Function<ExternalIssue, ExternalIssue>(){

        public ExternalIssue apply(@Nullable ExternalIssue input) {
            if (input != null) {
                ArrayList customFields = Lists.newArrayList(input.getExternalCustomFieldValues());
                String caseUrl = UriBuilder.fromUri((String)(CaseFactory.this.fogBugzClient.getApiClient().getBaseURLwithSlash() + "default.asp")).build(new Object[0]).toString() + "?" + input.getExternalId();
                ExternalCustomFieldValue urlCFValue = new ExternalCustomFieldValue("External issue URL", "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher", caseUrl);
                customFields.add(urlCFValue);
                input.setExternalCustomFieldValues(customFields);
            }
            return input;
        }
    };
    private final Function<ExternalIssue, ExternalIssue> MAP_VALUES_AND_USERS = new Function<ExternalIssue, ExternalIssue>(){

        public ExternalIssue apply(ExternalIssue input) {
            if (StringUtils.isNotEmpty((String)input.getIssueType())) {
                input.setIssueType(CaseFactory.this.configBean.getValueMappingHelper().getValueMappingForImport("sCategory", input.getIssueType()));
            }
            if (StringUtils.isNotEmpty((String)input.getPriority())) {
                input.setPriority(CaseFactory.this.configBean.getValueMappingHelper().getValueMappingForImport("sPriority", input.getPriority()));
            }
            if (StringUtils.isNotEmpty((String)input.getStatus())) {
                input.setStatus(CaseFactory.this.configBean.getValueMappingHelper().getValueMappingForImport("sStatus", input.getStatus()));
            }
            if (StringUtils.isNotEmpty((String)input.getResolution())) {
                input.setResolution(CaseFactory.this.configBean.getValueMappingHelper().getValueMappingForImport("sStatus (Resolution)", input.getResolution()));
            }
            input.setReporter(CaseFactory.this.getUsernameForId(input.getReporter()));
            input.setAssignee(CaseFactory.this.getUsernameForId(input.getAssignee()));
            if (input.getComments() != null) {
                ArrayList comments = Lists.newArrayList();
                for (ExternalComment comment : input.getComments()) {
                    comments.add(new ExternalComment(comment.getBody(), CaseFactory.this.getUsernameForId(comment.getAuthor()), comment.getCreated()));
                }
                input.setComments(comments);
            }
            if (input.getAttachments() != null) {
                for (ExternalAttachment attachment : input.getAttachments()) {
                    attachment.setAttacher(CaseFactory.this.getUsernameForId(attachment.getAttacher()));
                }
            }
            return input;
        }
    };

    public CaseFactory(String projectId, ImportLogger log, Map<String, ExternalUser> userIdToExternalUser, FogBugzHostedConfigBean configBean) {
        this.fogBugzClient = configBean.getClient();
        this.projectId = projectId;
        this.log = log;
        this.userIdToExternalUser = userIdToExternalUser;
        this.configBean = configBean;
        this.caseParser = new CaseParser(log);
    }

    @Override
    public List<ExternalIssue> getNewItems() throws Exception {
        List<Element> cases;
        try {
            cases = this.getCases(50);
        }
        catch (FogBugzParsingException e) {
            cases = this.recoverParsingError();
        }
        this.links.addAll((Collection<ExternalLink>)ImmutableList.copyOf(LinkParser.parseLinks(cases)));
        Iterable parsedIssues = Iterables.transform((Iterable)Iterables.transform(cases, (Function)this.caseParser), this.ADD_EXTERNAL_ISSUE_URL);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)parsedIssues, this.MAP_VALUES_AND_USERS));
    }

    private List<Element> recoverParsingError() throws FogBugzRemoteException {
        ArrayList cases = Lists.newArrayList();
        for (int i = 0; i < 50; ++i) {
            try {
                cases.addAll(this.getCases(1));
                continue;
            }
            catch (FogBugzParsingException e) {
                cases.addAll(this.getCaseWithParsingError());
                break;
            }
        }
        return cases;
    }

    private List<Element> getCases(int limit) throws FogBugzRemoteException {
        return this.downloadCases(limit, ALL_COLUMNS);
    }

    private List<Element> getCaseWithParsingError() throws FogBugzRemoteException {
        String text;
        InputStream inputStream = this.fogBugzClient.searchForCase(this.getSearchQuery(), ALL_COLUMNS);
        try {
            text = String.format("This case couldn't be parsed correctly, most probably due to nested CDATA element.\nThe recovered case data:\n{code}%s{code}", IOUtils.toString((InputStream)inputStream));
        }
        catch (IOException e) {
            throw new FogBugzRemoteException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        List<Element> elements = this.downloadCases(1, COLUMNS_FOR_PARSING_ERROR);
        if (elements.isEmpty()) {
            throw new IllegalStateException("Cannot recover from invalid case XML format");
        }
        this.putDescriptionToCase(elements.get(0), text);
        this.log.warn("Case with id %d couldn't be parsed correctly, recovered information are stored in issue description", this.getCaseId(elements.get(0)));
        return elements;
    }

    private void putDescriptionToCase(Element errorCase, String text) {
        Element events = new Element("events");
        Element event = new Element("event");
        Element s = new Element("s");
        s.setText(text);
        event.getChildren().add(s);
        events.getChildren().add(event);
        errorCase.getChildren().add(events);
    }

    private List<Element> downloadCases(int limit, String columns) throws FogBugzRemoteException {
        List<Element> elements = this.fogBugzClient.searchForCases(this.getSearchQuery(), columns, limit);
        if (!elements.isEmpty()) {
            this.lastCaseId = this.getCaseId(elements.get(elements.size() - 1));
        }
        return elements;
    }

    private long getCaseId(Element element) {
        try {
            return Long.parseLong(element.getAttribute("ixBug").getValue());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Malformed XML while trying to get case count number", e);
        }
    }

    private String getSearchQuery() {
        return String.format("project:=%s orderby:\"ixBug\" ixBug:\"%d..\"", this.projectId, this.lastCaseId + 1L);
    }

    @Nullable
    private String getUsernameForId(@Nullable String id) {
        if (id == null) {
            return null;
        }
        ExternalUser user = this.userIdToExternalUser.get(id);
        return user != null ? user.getName() : null;
    }

    public List<ExternalLink> getLinks() {
        return this.links;
    }
}

