/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.config;

import com.atlassian.jira.plugins.importer.imports.AbstractStatusValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class StatusValueMapper
extends AbstractStatusValueMapper {
    public static final String FIELD = "sStatus";

    public StatusValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext, AbstractConfigBean2 configBean) {
        super(jdbcConnection, authenticationContext, configBean);
    }

    @Override
    public String getExternalFieldId() {
        return FIELD;
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT DISTINCT sStatus FROM Bug, Status WHERE Bug.ixStatus=Status.ixStatus";
    }

    @Override
    public Set<String> getDistinctValues() {
        HashSet set = Sets.newHashSet(super.getDistinctValues());
        set.add("Closed");
        return set;
    }

    @Override
    public String transformStatus(String status) {
        return StatusValueMapper.getCleanedStatus(super.transformStatus(status));
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("Active", 1), new ValueMappingEntry("Resolved", 5), new ValueMappingEntry("Closed", 6)}).build();
    }

    public static String getCleanedStatus(String fogBugzStatus) {
        int bracket = fogBugzStatus.indexOf("(");
        return StringUtils.trimToEmpty((String)(bracket != -1 ? fogBugzStatus.substring(0, bracket) : fogBugzStatus));
    }
}

