/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.customfields.converters.DateTimePickerConverter;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.fogbugz.FogBugzConfigBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.AffectsVersionTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.AttachmentTransformerFactory;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.ComponentTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.DuplicateLinksTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.FixForVersionTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.IssueTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.ProjectTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.RelatedLinksTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.SubcaseLinksTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.UserTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FogBugzDataBean
extends AbstractDataBean<FogBugzConfigBean> {
    public static final String ISSUE_KEY_REGEX = "(?:bug|case|cases|case_id):? #?([0-9 ,]+)";
    private final JdbcConnection jdbcConnection;
    private final AttachmentTransformerFactory attachmentTransformerFactory;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private Set<ExternalUser> allUsers = ImmutableSet.of();

    public FogBugzDataBean(FogBugzConfigBean configBean, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(configBean);
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.jdbcConnection = configBean.getJdbcConnection();
        this.attachmentTransformerFactory = new AttachmentTransformerFactory(this.jdbcConnection);
    }

    @Override
    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    @Override
    public Set<ExternalUser> getAllUsers(ImportLogger importLogger) {
        this.allUsers = new HashSet<ExternalUser>(this.jdbcConnection.queryDb(new UserTransformer((FogBugzConfigBean)this.configBean, importLogger)));
        return this.allUsers;
    }

    @Override
    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        return Sets.newHashSet(this.jdbcConnection.queryDb(new ProjectTransformer((FogBugzConfigBean)this.configBean)));
    }

    @Override
    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        List<ExternalVersion> versions = this.jdbcConnection.queryDb(new FixForVersionTransformer(externalProject, importLogger));
        List<ExternalVersion> affectsVersions = this.jdbcConnection.queryDb(new AffectsVersionTransformer(externalProject, importLogger));
        versions.addAll(affectsVersions);
        return versions;
    }

    @Override
    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(new ComponentTransformer((FogBugzConfigBean)this.configBean, externalProject, importLogger));
    }

    @Override
    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(new IssueTransformer((FogBugzConfigBean)this.configBean, externalProject, new DateTimePickerConverter(this.dateTimeFormatterFactory), this.allUsers, importLogger)).iterator();
    }

    @Override
    public Collection<ExternalLink> getLinks(ImportLogger log) {
        List<ExternalLink> links = this.jdbcConnection.queryDb(new DuplicateLinksTransformer((FogBugzConfigBean)this.configBean));
        links.addAll(this.jdbcConnection.queryDb(new RelatedLinksTransformer((FogBugzConfigBean)this.configBean)));
        links.addAll(this.jdbcConnection.queryDb(new SubcaseLinksTransformer((FogBugzConfigBean)this.configBean)));
        return links;
    }

    @Override
    public long getTotalIssues(final Set<ExternalProject> selectedProjects, ImportLogger log) {
        if (selectedProjects.isEmpty()) {
            return 0L;
        }
        List<Long> count = this.jdbcConnection.queryDb(new ResultSetTransformer<Long>(){

            @Override
            public String getSqlQuery() {
                HashSet ids = Sets.newHashSet();
                for (ExternalProject project : selectedProjects) {
                    try {
                        ids.add(Long.parseLong(project.getId()));
                    }
                    catch (Exception exception) {}
                }
                return String.format("SELECT count(*) AS issues FROM Bug WHERE ixProject IN (%s)", Joiner.on((String)", ").join((Iterable)ids));
            }

            @Override
            public Long transform(ResultSet rs) throws SQLException {
                return rs.getLong("issues");
            }
        });
        return count.iterator().next();
    }

    @Override
    public String getUnusedUsersGroup() {
        return ((FogBugzConfigBean)this.configBean).getUnusedUsersGroup();
    }

    @Override
    public void cleanUp() {
        this.jdbcConnection.closeConnection();
    }

    @Override
    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        String externalIssueOldId = externalIssue.getExternalId();
        List<ExternalAttachment> listOfExternalAttachments = this.jdbcConnection.queryDb(this.attachmentTransformerFactory.create(externalIssueOldId, (FogBugzConfigBean)this.configBean, log));
        return listOfExternalAttachments;
    }

    @Override
    public String getIssueKeyRegex() {
        return ISSUE_KEY_REGEX;
    }
}

