/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.fogbugz.config.FogBugzValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FogBugzConfigBean
extends AbstractDatabaseConfigBean {
    private static final String COMPUTER_FIELD = "sComputer";
    private static final String FULL_NAME_FIELD = "sFullName";
    private static final String S_FORMAT_FIELD = "sFormat";
    public static final String DUPLICATES_LINK_NAME = "Duplicates";
    public static final String SEE_ALSO_LINK_NAME = "See also";
    public static final String SUBCASE_LINK_NAME = "Parent / Subcase";
    public static final String UNUSED_USERS_GROUP = "fogbugz-import-unused-users";
    private static final String BUG_EVENT_TABLE = "BugEvent";
    private final boolean bugEventSformatPresent = this.isBugEventSformatColumnPresent();

    public FogBugzConfigBean(JdbcConnection jdbcConnection) {
        super(jdbcConnection);
    }

    @VisibleForTesting
    protected boolean isBugEventSformatColumnPresent() {
        try {
            return SqlUtils.getColumnNames(this.jdbcConnection.getConnection(), BUG_EVENT_TABLE).contains(S_FORMAT_FIELD);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ValueMappingHelper initializeValueMappingHelper() {
        FogBugzValueMappingDefinitionsFactory mappingDefinitionsFactory = new FogBugzValueMappingDefinitionsFactory(this, this.getJiraAuthenticationContext(), this.getConstantsManager(), this.getFieldManager());
        return new ValueMappingHelperImpl(mappingDefinitionsFactory);
    }

    @Override
    public List<String> getExternalProjectNames() {
        return this.getJdbcConnection().queryDb(new ResultSetTransformer<String>(){

            @Override
            public String getSqlQuery() {
                return "SELECT ixProject, sProject, sFullName FROM Person, Project WHERE ixPersonOwner = ixPerson";
            }

            @Override
            public String transform(ResultSet rs) throws SQLException {
                return rs.getString("sProject");
            }
        });
    }

    @Override
    public List<ExternalCustomField> getCustomFields() {
        ArrayList fields = Lists.newArrayList((Object[])new ExternalCustomField[]{new ExternalCustomField("sCustomerEmail", "Customer Email", "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher"), new ExternalCustomField(COMPUTER_FIELD, "Computer", "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher")});
        return fields;
    }

    public String getUsernameForFullName(String sFullName) {
        String translatedUserName = this.getValueMappingHelper().getValueMappingForImport(FULL_NAME_FIELD, sFullName);
        if (sFullName.equals(translatedUserName)) {
            return FogBugzConfigBean.extractUsername(sFullName);
        }
        return translatedUserName;
    }

    protected static String extractUsername(String fullName) {
        String username;
        if (StringUtils.contains((String)fullName, (String)" ")) {
            username = StringUtils.replaceChars((String)fullName, (String)"-'()", (String)"");
            username = StringUtils.substring((String)username, (int)0, (int)1) + StringUtils.substringAfter((String)username, (String)" ");
            username = StringUtils.replaceChars((String)username, (String)" ", (String)"");
        } else {
            username = fullName;
        }
        return StringUtils.lowerCase((String)username);
    }

    @Override
    public List<String> getLinkNamesFromDb() {
        return ImmutableList.of((Object)DUPLICATES_LINK_NAME, (Object)SEE_ALSO_LINK_NAME, (Object)SUBCASE_LINK_NAME);
    }

    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }

    public boolean isBugEventSformatPresent() {
        return this.bugEventSformatPresent;
    }
}

