/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.web;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ConsoleImportLogger;
import com.atlassian.jira.plugins.importer.managers.CreateConstantsManager;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.csv.AbstractCsvValueMappingPage;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CsvValueMappingsPage
extends AbstractCsvValueMappingPage {
    private String constantType;
    private String constantValue;
    private String constantField;
    private boolean addConstant;
    private Set<ExternalProject> externalProjects = null;
    private final CreateConstantsManager createConstantsManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;

    public CsvValueMappingsPage(UsageTrackingService usageTrackingService, CreateConstantsManager createConstantsManager, @ComponentImport ConstantsManager constantsManager, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport IssueLinkTypeManager issueLinkTypeManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport WorkflowManager workflowManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, constantsManager, customFieldManager, issueLinkTypeManager);
        this.createConstantsManager = createConstantsManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
    }

    @RequiresXsrfCheck
    public String doAddConstant() throws Exception {
        GoodCsvConfigBean configBean = this.getConfigBean();
        if (StringUtils.isNotEmpty((String)this.getConstantType()) && StringUtils.isNotEmpty((String)this.getConstantValue()) && configBean != null) {
            String id = this.createConstantsManager.addConstant(this.getConstantValue(), this.getConstantType());
            configBean.putNewValueMapping(this.constantField, this.constantValue, id);
        }
        return this.getRedirect(this.getImporterBaseUrlWithSlash() + this.getActionName() + "!default.jspa?externalSystem=" + this.getExternalSystem());
    }

    public String getConstantType() {
        return this.constantType;
    }

    public void setConstantType(String constantType) {
        this.constantType = constantType;
    }

    public String getConstantValue() {
        return this.constantValue;
    }

    public void setConstantValue(String constantValue) {
        this.constantValue = constantValue;
    }

    public String getConstantField() {
        return this.constantField;
    }

    public void setConstantField(String constantField) {
        this.constantField = constantField;
    }

    public boolean isAddConstant() {
        return this.addConstant;
    }

    public void setAddConstant(boolean addConstant) {
        this.addConstant = addConstant;
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.addConstant) {
            return this.doAddConstant();
        }
        return super.doExecute();
    }

    public Collection<Resolution> getResolutions() {
        return this.constantsManager.getResolutionObjects();
    }

    public Collection<Status> getStatuses() {
        Set<ExternalProject> projects = this.getDestinationProjects();
        Iterable workflowSchemes = Iterables.transform(projects, (Function)new Function<ExternalProject, WorkflowScheme>(){

            public WorkflowScheme apply(ExternalProject input) {
                Project project = CsvValueMappingsPage.this.getProjectManager().getProjectObjByKey(input.getKey());
                return project != null ? CsvValueMappingsPage.this.workflowSchemeManager.getWorkflowSchemeObj(project) : CsvValueMappingsPage.this.workflowSchemeManager.getDefaultWorkflowScheme();
            }
        });
        Iterable allAvailableStatuses = Iterables.concat((Iterable)Iterables.transform((Iterable)workflowSchemes, (Function)new Function<WorkflowScheme, Iterable<Status>>(){

            public Iterable<Status> apply(WorkflowScheme input) {
                return CsvValueMappingsPage.this.getAllStatusesConnectedToWorkflowScheme(input);
            }
        }));
        return ImmutableSet.copyOf((Iterable)allAvailableStatuses);
    }

    private Iterable<Status> getAllStatusesConnectedToWorkflowScheme(WorkflowScheme workflowScheme) {
        ImmutableSet workflows = ImmutableSet.copyOf(workflowScheme.getMappings().values());
        return Iterables.concat((Iterable)Iterables.transform((Iterable)workflows, (Function)new Function<String, Collection<Status>>(){

            public Collection<Status> apply(String input) {
                return CsvValueMappingsPage.this.workflowManager.getWorkflow(input).getLinkedStatusObjects();
            }
        }));
    }

    private Set<ExternalProject> getDestinationProjects() {
        if (this.externalProjects == null) {
            try {
                this.externalProjects = this.getController().createDataBean().getAllProjects(ConsoleImportLogger.INSTANCE);
            }
            catch (Exception e) {
                this.log.warn((Object)"Cannot read projects from csv", (Throwable)e);
            }
        }
        return this.externalProjects;
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.set.up.value.mappings");
    }
}

