/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.web;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.csv.AbstractCsvProjectMappingPage;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.ImmutableList;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class CsvProjectMappingsPage
extends AbstractCsvProjectMappingPage {
    private final DateTimeFormatter dateTimeFormatter;
    private boolean readFromCsv;
    private String userEmailSuffix;
    private String dateImportFormat;

    public CsvProjectMappingsPage(UsageTrackingService usageTrackingService, @ComponentImport ProjectService projectService, @ComponentImport ProjectManager projectManager, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport DateTimeFormatter dateTimeFormatter) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, projectService, projectManager);
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public String doDefault() throws Exception {
        String result = super.doDefault();
        if ("input".equals(result)) {
            GoodCsvConfigBean configBean = this.getConfigBean();
            this.readFromCsv = configBean.isReadingProjectFromCsv();
            this.userEmailSuffix = configBean.getUserEmailSuffix();
            this.dateImportFormat = StringUtils.defaultIfEmpty((String)configBean.getDateFormat(), (String)this.dateTimeFormatter.getFormatHint());
        }
        return result;
    }

    @Override
    @RequiresXsrfCheck
    protected void doValidation() {
        super.doValidation();
        GoodCsvConfigBean configBean = this.getConfigBean();
        if (configBean == null) {
            return;
        }
        if (this.isPreviousClicked()) {
            return;
        }
        Map actionParams = ActionContext.getParameters();
        String projectName = ParameterUtils.getStringParam((Map)actionParams, (String)"CSV_project_name");
        String projectKey = ParameterUtils.getStringParam((Map)actionParams, (String)"CSV_project_key");
        if (!this.readFromCsv) {
            Project jiraProject = this.projectManager.getProjectObjByKey(projectKey);
            if (jiraProject != null) {
                if (!jiraProject.getKey().equals(projectKey) || !jiraProject.getName().equals(projectName)) {
                    this.addError("project", this.getText("jira-importer-plugin.project.key.or.name.already.used"));
                }
            } else {
                this.addError("project", this.getText("jira-importer-plugin.general.project.dont.exists"));
            }
        }
        if (StringUtils.isNotBlank((String)this.dateImportFormat)) {
            try {
                new SimpleDateFormat(this.dateImportFormat);
            }
            catch (IllegalArgumentException e) {
                this.addError("dateImportFormat", this.getText("jira-importer-plugin.csv.misc.page.invalid.date.format", e.getMessage()));
            }
        }
        configBean.setReadingProjectFromCsv(this.readFromCsv);
        configBean.setDateFormat(this.dateImportFormat);
        configBean.setUserEmailSuffix(this.userEmailSuffix);
        configBean.setPickedProject(projectKey, projectName, null, null);
    }

    @Override
    public Collection<Project> getApplicableProjects() {
        return this.helper.getExistingProjects();
    }

    public String getReadFromCsv() {
        return Boolean.toString(this.readFromCsv);
    }

    public void setReadFromCsv(String readFromCsv) {
        this.readFromCsv = Boolean.parseBoolean(readFromCsv);
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.wizard.projectmappings.title");
    }

    public String getUserEmailSuffix() {
        return StringUtils.removeStart((String)this.userEmailSuffix, (String)"@");
    }

    public void setUserEmailSuffix(String userEmailSuffix) {
        this.userEmailSuffix = "@" + StringUtils.defaultString((String)userEmailSuffix);
    }

    public String getDateImportFormat() {
        return this.dateImportFormat;
    }

    public void setDateImportFormat(String dateImportFormat) {
        this.dateImportFormat = dateImportFormat;
    }

    @Override
    @Nonnull
    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-plugin:csvProjectMappingsPage");
    }
}

