/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.compatibility.ProjectTypeInfo;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.external.ExternalProjectUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.csv.AvailableJiraFieldMappings;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ConsoleImportLogger;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.csv.AbstractCsvFieldMappingPage;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import webwork.action.ActionContext;

public class CsvFieldMappingsPage
extends AbstractCsvFieldMappingPage {
    public static final Function<ProjectTypeInfo, String> PROJECT_TYPE_TO_NAME = new Function<ProjectTypeInfo, String>(){

        public String apply(ProjectTypeInfo input) {
            return input.getKey();
        }
    };
    private static Set<String> WHITE_LISTED_CF_TYPES = ImmutableSet.of((Object)"com.pyxis.greenhopper.jira:gh-epic-color", (Object)"com.pyxis.greenhopper.jira:gh-epic-link", (Object)"com.pyxis.greenhopper.jira:gh-epic-label", (Object)"com.pyxis.greenhopper.jira:gh-epic-status");
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;
    private final AvailableJiraFieldMappings jiraFieldMappings;
    private final CompatibilityBridgeUtils bridgeUtils;
    private Map<String, Map<String, String>> singleValueMappings;
    private Map<String, Map<String, String>> multipleValueMappings;

    public CsvFieldMappingsPage(UsageTrackingService usageTrackingService, AvailableJiraFieldMappings jiraFieldMappings, CompatibilityBridgeUtils bridgeUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport ProjectManager projectManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, customFieldManager, eventPublisher);
        this.authenticationContext = authenticationContext;
        this.jiraFieldMappings = jiraFieldMappings;
        this.projectManager = projectManager;
        this.bridgeUtils = bridgeUtils;
    }

    @Override
    @Nonnull
    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-plugin:csvFieldMappingsPage");
    }

    @Override
    @RequiresXsrfCheck
    protected void doValidation() {
        super.doValidation();
        if (!this.isNextClicked()) {
            return;
        }
        ImporterController controller = this.getController();
        GoodCsvConfigBean configBean = this.getConfigBean();
        if (configBean.isReadingProjectFromCsv()) {
            this.validateProjectRequiredFields(configBean, controller);
        }
        if (configBean.containsHeaderMappedTo("subtask-parent-id")) {
            if (!configBean.containsHeaderMappedTo("issue-id")) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.mappings.subtasks.mustincludeissueid"));
            }
            if (!configBean.containsHeaderMappedTo("issuetype")) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.mappings.subtasks.mustmaptype", this.getText("issue.field.issuetype")));
            }
        }
        if (!this.isAttachmentsEnabled() && configBean.containsHeaderMappedTo("attachment")) {
            this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.attachments.disabled"), this.getText("jira-importer-plugin.importer.attachments.can.be.enabled", ActionContext.getContext().getRequestImpl().getContextPath() + "/secure/admin/jira/ViewAttachmentSettings.jspa"));
        }
    }

    protected void validateProjectRequiredFields(GoodCsvConfigBean configBean, ImporterController controller) {
        boolean hasProjectKey = configBean.containsHeaderMappedTo("project.key");
        boolean hasProjectName = configBean.containsHeaderMappedTo("project.name");
        boolean hasProjectType = configBean.containsHeaderMappedTo("project.type");
        List<ProjectTypeInfo> projectTypes = this.bridgeUtils.getProjectTypes();
        if (!hasProjectKey) {
            this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.must.have.project.key"));
        }
        if (!hasProjectName) {
            this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.must.have.project.name"));
        }
        if (!hasProjectType && !projectTypes.isEmpty()) {
            this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.must.have.project.type", Joiner.on((String)", ").join(Iterables.transform(projectTypes, PROJECT_TYPE_TO_NAME))));
        }
        if (hasProjectKey && hasProjectName && (hasProjectType || projectTypes.isEmpty())) {
            try {
                ImportDataBean dataBean = controller.createDataBean();
                for (ExternalProject project : dataBean.getAllProjects(ConsoleImportLogger.INSTANCE)) {
                    Project jiraProject = ExternalProjectUtils.getProject(this.projectManager, project);
                    if (jiraProject != null) {
                        if (jiraProject.getKey().equals(project.getKey()) && jiraProject.getName().equals(project.getName())) continue;
                        this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.invalid.project.key", project.getKey(), this.getText("jira-importer-plugin.project.key.or.name.already.used")));
                        continue;
                    }
                    ProjectService.CreateProjectValidationResult result = this.bridgeUtils.validateCreateProject(this.authenticationContext.getUser(), project.getName(), project.getKey(), project.getDescription(), this.authenticationContext.getUser().getName(), project.getUrl(), null, project.getType(), null);
                    if (result.isValid()) continue;
                    Map errors = result.getErrorCollection().getErrors();
                    if (errors.size() > 0) {
                        this.addErrorMessages(project, errors);
                        continue;
                    }
                    for (String error : result.getErrorCollection().getErrorMessages()) {
                        this.addErrorMessage(error);
                    }
                }
            }
            catch (Exception e) {
                this.addErrorMessage(e.getMessage());
                this.log.warn((Object)"Error during page validation", (Throwable)e);
            }
        }
    }

    private void addErrorMessages(ExternalProject project, Map<String, String> errors) {
        for (Map.Entry<String, String> field : errors.entrySet()) {
            if ("projectName".equals(field.getKey())) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.invalid.project.name", project.getName(), field.getValue()));
                continue;
            }
            if ("projectKey".equals(field.getKey())) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.invalid.project.key", project.getKey(), field.getValue()));
                continue;
            }
            if ("projectUrl".equals(field.getKey())) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.invalid.project.url", project.getUrl(), field.getValue()));
                continue;
            }
            if ("projectDescription".equals(field.getKey())) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.invalid.project.description", project.getDescription(), field.getValue()));
                continue;
            }
            if ("projectLead".equals(field.getKey())) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.invalid.project.lead", project.getLead(), field.getValue()));
                continue;
            }
            if ("projectType".equals(field.getKey())) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.invalid.project.type", project.getType(), field.getValue()));
                continue;
            }
            this.addErrorMessage(field.getValue());
        }
    }

    @Override
    public ImmutableSet<CustomField> getCustomFields() {
        List allCustomFields = this.customFieldManager.getCustomFieldObjects();
        LinkedHashSet availableCustomFields = Sets.newLinkedHashSet();
        Project staticProject = this.getProjectManager().getProjectObjByKey(this.getConfigBean().getProjectKey("CSV"));
        if (!this.getConfigBean().isReadingProjectFromCsv() && staticProject != null) {
            String projectKey = this.getConfigBean().getProjectKey("CSV");
            Project project = this.getProjectManager().getProjectObjByKey(projectKey);
            for (CustomField customFieldObject : allCustomFields) {
                if (!customFieldObject.isAllProjects() && !customFieldObject.getAssociatedProjectObjects().contains(project) && !this.isWhitelisted(customFieldObject)) continue;
                availableCustomFields.add(customFieldObject);
            }
        } else {
            for (CustomField customFieldObject : allCustomFields) {
                if (!customFieldObject.isAllProjects() && !this.isWhitelisted(customFieldObject)) continue;
                availableCustomFields.add(customFieldObject);
            }
        }
        return ImmutableSet.copyOf((Collection)availableCustomFields);
    }

    private boolean isWhitelisted(CustomField customFieldObject) {
        CustomFieldType customFieldType = customFieldObject.getCustomFieldType();
        return customFieldType != null && customFieldType.getKey() != null && WHITE_LISTED_CF_TYPES.contains(customFieldType.getKey());
    }

    @Override
    protected Map<String, Map<String, String>> getMappingsForSingle() {
        if (this.singleValueMappings == null) {
            this.singleValueMappings = this.jiraFieldMappings.getAvailableMappingsSingleField(this.getConfigBean().isReadingProjectFromCsv());
        }
        return this.singleValueMappings;
    }

    @Override
    protected Map<String, Map<String, String>> getMappingsForMultiple() {
        if (this.multipleValueMappings == null) {
            this.multipleValueMappings = this.jiraFieldMappings.getAvailableMappingsMultipleField();
        }
        return this.multipleValueMappings;
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.set.up.field.mappings");
    }
}

