/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCommentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserNameMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.collect.Multimap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PvcsComment
implements ExternalCommentMapper {
    private static final String STAR_TEAM_FORMAT = "MM/dd/yy hh:mm:ss a";

    @Override
    @Nullable
    public List<ExternalComment> buildFromMultiMap(Multimap<String, String> bean, ExternalUserNameMapper userNameMapper, ImportLogger log) {
        Collection commentBodies = bean.get((Object)"comment");
        if (commentBodies != null && !commentBodies.isEmpty()) {
            ArrayList<ExternalComment> externalComments = new ArrayList<ExternalComment>(commentBodies.size());
            SimpleDateFormat startTeamDateFormat = new SimpleDateFormat(STAR_TEAM_FORMAT);
            for (String commentBody : commentBodies) {
                if (!StringUtils.isNotEmpty((String)commentBody)) continue;
                String user = null;
                Date timePerformed = null;
                try {
                    StringTokenizer st = new StringTokenizer(commentBody, ":");
                    st.nextToken();
                    user = userNameMapper.extractUserName(StringUtils.strip((String)st.nextToken()));
                    String timeString = st.nextToken() + ":" + st.nextToken() + ":" + st.nextToken();
                    timePerformed = startTeamDateFormat.parse(timeString);
                }
                catch (Exception e) {
                    log.warn(e, "Exception occurred parsing comment. Some values may not be set", new Object[0]);
                }
                externalComments.add(new ExternalComment(commentBody, user, timePerformed));
            }
            return externalComments;
        }
        return null;
    }
}

