/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDateParser;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalIssueMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.TimeEstimateConverter;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class DefaultExternalIssueMapper
implements ExternalIssueMapper {
    public static final String SUBTASK_PARENT_ID = "subtask-parent-id";
    public static final String ISSUE_ID = "issue-id";
    private TimeEstimateConverter timeEstimateConverter;
    private final CsvDateParser dateParser;
    public static final String CLEAR_VALUE_MARKER = "<<!clear!>>";
    public static final Date DATE_CLEAR_VALUE_MARKER = new Date(Long.MAX_VALUE);

    public DefaultExternalIssueMapper(TimeEstimateConverter timeEstimateConverter, CsvDateParser dateParser) {
        this.timeEstimateConverter = timeEstimateConverter;
        this.dateParser = dateParser;
    }

    private Iterable<String> optionalOp(Multimap<String, String> bean, String fieldName) {
        Collection values = bean.get((Object)fieldName);
        if (!values.isEmpty()) {
            if (values.contains(CLEAR_VALUE_MARKER)) {
                return Collections.singleton(CLEAR_VALUE_MARKER);
            }
            return Iterables.limit((Iterable)values, (int)1);
        }
        return Collections.emptyList();
    }

    private Iterable<Date> optionalDateTime(Multimap<String, String> bean, String fieldName, ImportLogger log) {
        Collection values = bean.get((Object)fieldName);
        if (!values.isEmpty()) {
            String dateStr = (String)values.iterator().next();
            try {
                return Collections.singleton(this.dateParser.parseDateTime(dateStr));
            }
            catch (ParseException e) {
                log.warn("Unable to parse created date: %s", dateStr);
            }
        }
        return Collections.emptyList();
    }

    private Iterable<Date> optionalClearableDate(Multimap<String, String> bean, String fieldName, ImportLogger log) {
        Collection values = bean.get((Object)fieldName);
        if (!values.isEmpty()) {
            String dateStr = (String)values.iterator().next();
            try {
                if (CLEAR_VALUE_MARKER.equals(dateStr)) {
                    return Collections.singleton(DATE_CLEAR_VALUE_MARKER);
                }
                return Collections.singleton(this.dateParser.parseDate(dateStr));
            }
            catch (ParseException e) {
                log.warn("Unable to parse date: %s", dateStr);
            }
        }
        return Collections.emptyList();
    }

    private Iterable<Date> optionalClearableDateTime(Multimap<String, String> bean, String fieldName, ImportLogger log) {
        Collection values = bean.get((Object)fieldName);
        if (!values.isEmpty()) {
            String dateStr = (String)values.iterator().next();
            try {
                if (CLEAR_VALUE_MARKER.equals(dateStr)) {
                    return Collections.singleton(DATE_CLEAR_VALUE_MARKER);
                }
                return Collections.singleton(this.dateParser.parseDateTime(dateStr));
            }
            catch (ParseException e) {
                log.warn("Unable to parse datetime: %s", dateStr);
            }
        }
        return Collections.emptyList();
    }

    private <T> Iterable<T> getFirstElementIfPresent(Iterable<T> iterable) {
        return Iterables.limit(iterable, (int)1);
    }

    @Override
    public ExternalIssue buildFromMultiMap(Multimap<String, String> bean, ImportLogger log) {
        ExternalIssue issue = new ExternalIssue();
        if (!bean.get((Object)ISSUE_ID).isEmpty()) {
            issue.setExternalId((String)Iterables.getFirst((Iterable)bean.get((Object)ISSUE_ID), null));
        }
        for (String string : this.optionalOp(bean, "reporter")) {
            issue.setReporter(string);
        }
        for (String string : this.optionalOp(bean, "assignee")) {
            issue.setAssignee(string);
        }
        for (String string : this.optionalOp(bean, "issuetype")) {
            issue.setIssueType(string);
        }
        for (String string : this.optionalOp(bean, "priority")) {
            issue.setPriority(string);
        }
        for (String string : this.optionalOp(bean, "summary")) {
            issue.setSummary(string);
        }
        for (String string : this.getFirstElementIfPresent(bean.get((Object)"issuekey"))) {
            issue.setKey(string);
        }
        for (String string : this.optionalOp(bean, "description")) {
            issue.setDescription(string);
        }
        for (String string : this.optionalOp(bean, "environment")) {
            issue.setEnvironment(string);
        }
        for (String string : this.optionalOp(bean, "resolution")) {
            issue.setResolution(string);
        }
        for (String string : this.getFirstElementIfPresent(bean.get((Object)"status"))) {
            issue.setStatus(string);
        }
        for (Date date : this.optionalDateTime(bean, "created", log)) {
            issue.setCreated(date);
        }
        for (Date date : this.optionalDateTime(bean, "updated", log)) {
            issue.setUpdated(date);
        }
        for (Date date : this.optionalClearableDateTime(bean, "resolutiondate", log)) {
            issue.setResolutionDate(date);
        }
        for (Date date : this.optionalClearableDate(bean, "duedate", log)) {
            issue.setDuedate(date);
        }
        if (!bean.get((Object)"timeoriginalestimate").isEmpty()) {
            try {
                String originalEstimateParam = (String)bean.get((Object)"timeoriginalestimate").iterator().next();
                Long l = this.timeEstimateConverter.convertEstimate(originalEstimateParam);
                issue.setOriginalEstimate(l);
            }
            catch (Exception e) {
                log.warn("Unable to parse original estimate: %s", bean.get((Object)"timeoriginalestimate"));
            }
        }
        if (!bean.get((Object)"timeestimate").isEmpty()) {
            try {
                String estimateParam = (String)bean.get((Object)"timeestimate").iterator().next();
                Long l = this.timeEstimateConverter.convertEstimate(estimateParam);
                issue.setEstimate(l);
            }
            catch (Exception e) {
                log.warn("Unable to parse estimate: %s", bean.get((Object)"timeestimate"));
            }
        }
        if (!bean.get((Object)"timespent").isEmpty()) {
            try {
                String timeSpentParam = (String)bean.get((Object)"timespent").iterator().next();
                Long l = this.timeEstimateConverter.convertEstimate(timeSpentParam);
                issue.setTimeSpent(l);
            }
            catch (Exception e) {
                log.warn("Unable to parse time spent: %s", bean.get((Object)"timespent"));
            }
        }
        for (String string : this.optionalOp(bean, "votes")) {
            try {
                issue.setVotes(CLEAR_VALUE_MARKER.equals(string) ? 0L : Long.valueOf(string));
            }
            catch (NumberFormatException e) {
                log.warn("Unable to parse votes: %s", bean.get((Object)"votes"));
            }
        }
        if (!bean.get((Object)"comments").isEmpty()) {
            issue.setComments(new ArrayList<ExternalComment>(bean.get((Object)"comments")));
        }
        return issue;
    }

    @Override
    public void setTimeTrackingConverter(TimeEstimateConverter timeEstimateConverter) {
        this.timeEstimateConverter = timeEstimateConverter;
    }
}

