/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.AbstractExternalUserMapper;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ConcatNameMapper
extends AbstractExternalUserMapper {
    private String emailSuffix;

    public ConcatNameMapper(@Nonnull CsvFieldMapping concattedNameField) {
        this(concattedNameField, null);
    }

    public ConcatNameMapper(@Nonnull CsvFieldMapping concattedNameField, @Nullable String emailSuffix) {
        super(concattedNameField);
        this.emailSuffix = StringUtils.defaultString((String)emailSuffix);
    }

    @Override
    protected Function<String, ExternalUser> getMapper() {
        return new Function<String, ExternalUser>(){

            public ExternalUser apply(@Nullable String concattedName) {
                String username = ConcatNameMapper.this.extractUserName(concattedName);
                String fullName = concattedName.substring(0, 1) + ". " + concattedName.substring(1, concattedName.length());
                return StringUtils.isNotEmpty((String)username) ? new ExternalUser(username.toLowerCase(), fullName, username.toLowerCase() + ConcatNameMapper.this.emailSuffix) : null;
            }
        };
    }

    @Override
    public String extractUserName(String concattedName) {
        return StringUtils.replaceChars((String)concattedName, (String)" '", (String)"");
    }
}

