/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.NamedExternalObject;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLine;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserMapper;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nonnull;

public abstract class AbstractExternalUserMapper
implements ExternalUserMapper {
    private final CsvFieldMapping fieldMapping;

    protected AbstractExternalUserMapper(CsvFieldMapping fieldMapping) {
        this.fieldMapping = fieldMapping;
    }

    @Override
    @Nonnull
    public Iterable<ExternalUser> buildFromMultiMap(MappedCsvLine line) {
        if (line.contains(this.fieldMapping)) {
            ImmutableList mappedUsers = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(line.get(this.fieldMapping), this.getMapper()), (Predicate)Predicates.notNull()));
            line.replace(this.fieldMapping, Iterables.transform((Iterable)mappedUsers, (Function)NamedExternalObject.NAME_FUNCTION));
            return mappedUsers;
        }
        return Collections.emptyList();
    }

    protected abstract Function<String, ExternalUser> getMapper();
}

