/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.imports.csv.CsvConfiguration;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDataBeanBuilder;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCommentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.StaticProjectMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.TimeEstimateConverter;
import com.atlassian.jira.plugins.importer.imports.csv.web.CsvFieldMappingsPage;
import com.atlassian.jira.plugins.importer.imports.csv.web.CsvProjectMappingsPage;
import com.atlassian.jira.plugins.importer.imports.csv.web.CsvSetupPage;
import com.atlassian.jira.plugins.importer.imports.csv.web.CsvValueMappingsPage;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.codehaus.jackson.JsonParseException;

public class CsvImporterController
extends AbstractImporterController {
    public static final String ID = "CSV";
    private final CustomFieldManager customFieldManager;
    private final AttachmentManager attachmentManager;
    private final JiraHome jiraHome;
    private final IssueManager issueManager;
    private final DateFieldFormat dateFormatter;
    private final DateTimeFormatter dateTimeFormatter;
    private final TimeZoneService timeZoneService;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueLinkTypeManager issueLinkTypeManager;

    public CsvImporterController(JiraDataImporter importer, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport JiraHome jiraHome, @ComponentImport AttachmentManager attachmentManager, @ComponentImport IssueManager issueManager, @ComponentImport DateFieldFormat dateFormatter, @ComponentImport DateTimeFormatter dateTimeFormatter, @ComponentImport TimeZoneService timeZoneService, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport IssueLinkTypeManager issueLinkTypeManager) {
        super(importer, "issue.importer.jira.csv.import.bean", ID);
        this.customFieldManager = customFieldManager;
        this.jiraHome = jiraHome;
        this.attachmentManager = attachmentManager;
        this.issueManager = issueManager;
        this.dateFormatter = dateFormatter;
        this.dateTimeFormatter = dateTimeFormatter;
        this.timeZoneService = timeZoneService;
        this.authenticationContext = authenticationContext;
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    @Override
    public boolean createImportProcessBean(AbstractSetupPage setupPage) {
        CsvSetupPage csvSetupPage = (CsvSetupPage)setupPage;
        ImportProcessBean bean = new ImportProcessBean();
        try {
            TimeZoneInfo timeZoneInfo = this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(this.authenticationContext.getUser()));
            GoodCsvConfigBean csvConfigBean = new GoodCsvConfigBean();
            csvConfigBean.setEncoding(csvSetupPage.getEncoding());
            csvConfigBean.setDelimiter(csvSetupPage.getDelimiterChar());
            csvConfigBean.setTimeZoneInfo(timeZoneInfo);
            csvConfigBean.setCsvFilePath(csvSetupPage.getTempAttachment().getFile());
            csvConfigBean.initFile();
            File temporaryConfigFile = csvSetupPage.getMultipart().getFile("configFile");
            if (temporaryConfigFile != null) {
                csvConfigBean.copyFromProperties(temporaryConfigFile);
            }
            bean.setConfigBean(csvConfigBean);
        }
        catch (Exception e) {
            if (e instanceof JsonParseException) {
                csvSetupPage.addErrorMessage(csvSetupPage.getText("jira-importer-plugin.import.setup.page.config.file.format.changed"));
            }
            csvSetupPage.addError("configFile", e.getMessage());
            return false;
        }
        this.storeImportProcessBeanInSession(bean);
        return true;
    }

    @Override
    public ImportDataBean createDataBean() throws Exception {
        TimeEstimateConverter customTimeEstimateConverter;
        ExternalCommentMapper customCommentMapper;
        List<ExternalUserMapper> customUserMappers;
        ImportProcessBean importProcessBean = this.getImportProcessBeanFromSession();
        GoodCsvConfigBean configBean = (GoodCsvConfigBean)importProcessBean.getConfigBean();
        CsvConfiguration config = new CsvConfiguration(configBean);
        CsvDataBeanBuilder builder = new CsvDataBeanBuilder(configBean, this.jiraHome, this.issueManager, this.attachmentManager, this.dateFormatter, this.dateTimeFormatter, this.issueLinkTypeManager, this.customFieldManager);
        if (!configBean.isReadingProjectFromCsv()) {
            builder.projectMapper(new StaticProjectMapper(configBean.getPickedProject()));
        }
        if ((customUserMappers = config.getCustomUserMappers()) != null) {
            builder.userMappers(customUserMappers);
        }
        if ((customCommentMapper = config.getCustomCommentMapper()) != null) {
            builder.commentMapper(customCommentMapper);
        }
        if ((customTimeEstimateConverter = config.getCustomTimeEstimateConverter()) != null) {
            builder.timeEstimateConverter(customTimeEstimateConverter);
        }
        return builder.build();
    }

    @Override
    public List<String> getSteps() {
        return Lists.newArrayList((Object[])new String[]{CsvSetupPage.class.getSimpleName(), CsvProjectMappingsPage.class.getSimpleName(), CsvFieldMappingsPage.class.getSimpleName(), CsvValueMappingsPage.class.getSimpleName()});
    }

    @Override
    public List<String> getStepNameKeys() {
        return Lists.newArrayList((Object[])new String[]{"jira-importer-plugin.wizard.step.CsvSetupPage", "jira-importer-plugin.wizard.step.CsvProjectMappingsPage", "jira-importer-plugin.wizard.step.CsvFieldMappingsPage", "jira-importer-plugin.wizard.step.CsvValueMappingsPage"});
    }
}

