/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.imports.csv.CsvFieldNameValidator;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLine;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLineHandler;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.supercsv.io.CsvListReader;

public class CsvFile {
    private static final Logger log = Logger.getLogger(CsvFile.class);
    private final String encoding;
    private final File csvFileLocation;
    private final Character delimiter;
    private String[] rawHeader;
    private Multimap<String, Integer> headerWithIndexes;
    private Multimap<String, String> uniqueValuesPerHeader;
    private List<String> firstRow;

    public CsvFile(String encoding, File csvFileLocation, Character delimiter) {
        this.encoding = encoding;
        this.csvFileLocation = csvFileLocation;
        this.delimiter = delimiter;
        this.readSampleData();
    }

    public ServiceResult validateCsvFile() {
        ErrorCollection errors = this.accessCsvFile(new CsvReaderAccessor(){

            @Override
            public void handleReader(CsvListReader reader, SimpleErrorCollection errors) throws IOException {
                Iterable badHeaders = Iterables.filter((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])reader.getHeader(true)), (Predicate)Predicates.notNull()), (Predicate)Predicates.not(CsvFieldNameValidator.HEADER_NAME_VALIDATOR));
                for (String badHeader : badHeaders) {
                    errors.addErrorMessage(CsvFile.msg("jira-importer-plugin.csv.setup.page.first.row", new Object[]{badHeader, CsvFile.msg("admin.errors.name.bracket.mismatch", new Object[0])}));
                }
                List lineAfterHeader = reader.read();
                if (lineAfterHeader == null) {
                    errors.addErrorMessage(CsvFile.msg("jira-importer-plugin.csv.could.not.parse.second.line", new Object[0]));
                } else if (lineAfterHeader.size() == 1 && "".equals(lineAfterHeader.iterator().next())) {
                    errors.addErrorMessage(CsvFile.msg("jira-importer-plugin.csv.second.line.empty", new Object[0]));
                }
            }
        });
        return new ServiceResultImpl(errors);
    }

    public ServiceOutcome<Multimap<String, String>> getUniqueValues(Iterable<String> headersToCheck) {
        if (this.hasAllNeededHeaders(headersToCheck)) {
            return ServiceOutcomeImpl.ok(this.uniqueValuesPerHeader);
        }
        this.uniqueValuesPerHeader = this.newSetMultiMap();
        final ImmutableSet indexes = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(headersToCheck, (Function)new Function<String, Collection<Integer>>(){

            public Collection<Integer> apply(String input) {
                return CsvFile.this.headerWithIndexes.get((Object)input);
            }
        })));
        ErrorCollection errors = this.accessCsvFile(new CsvReaderAccessor(){

            @Override
            public void handleReader(CsvListReader reader, SimpleErrorCollection errorCollection) throws IOException {
                List line;
                String[] header = reader.getHeader(true);
                while ((line = reader.read()) != null) {
                    for (Integer index : indexes) {
                        if (line.get(index) == null) continue;
                        CsvFile.this.uniqueValuesPerHeader.put((Object)header[index], line.get(index));
                    }
                }
            }
        });
        return ServiceOutcomeImpl.from((ErrorCollection)errors, this.uniqueValuesPerHeader);
    }

    private boolean hasAllNeededHeaders(Iterable<String> headersToCheck) {
        return this.uniqueValuesPerHeader != null && !this.uniqueValuesPerHeader.isEmpty() && Iterables.all(headersToCheck, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return CsvFile.this.uniqueValuesPerHeader.containsKey((Object)input);
            }
        });
    }

    private SetMultimap<String, String> newSetMultiMap() {
        return Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<String>>(){

            public Set<String> get() {
                return new HashSet<String>();
            }
        });
    }

    public Set<String> getHeader() {
        return this.headerWithIndexes.keySet();
    }

    private void readSampleData() {
        this.accessCsvFile(new CsvReaderAccessor(){

            @Override
            public void handleReader(CsvListReader reader, SimpleErrorCollection errorCollection) throws IOException {
                CsvFile.access$302(CsvFile.this, reader.getHeader(true));
                CsvFile.this.headerWithIndexes = (Multimap)ArrayListMultimap.create((int)CsvFile.this.rawHeader.length, (int)1);
                for (int i = 0; i < CsvFile.this.rawHeader.length; ++i) {
                    if (CsvFile.this.rawHeader[i] == null) {
                        ((CsvFile)CsvFile.this).rawHeader[i] = "";
                    }
                    CsvFile.this.headerWithIndexes.put((Object)CsvFile.this.rawHeader[i], (Object)i);
                }
                CsvFile.this.firstRow = reader.read();
            }
        });
    }

    public ErrorCollection handleCsvContent(final GoodCsvConfigBean configBean, final MappedCsvLineHandler lineHandler) {
        final Map<String, CsvFieldMapping> fieldMappings = configBean.getFieldMappings();
        return this.accessCsvFile(new CsvReaderAccessor(){

            @Override
            public void handleReader(CsvListReader reader, SimpleErrorCollection errorCollection) throws IOException {
                try {
                    List line;
                    reader.getHeader(true);
                    while ((line = reader.read()) != null) {
                        MappedCsvLine csvLine = new MappedCsvLine();
                        for (String mappedHeader : fieldMappings.keySet()) {
                            Collection indexes = CsvFile.this.headerWithIndexes.get((Object)mappedHeader);
                            CsvFieldMapping fieldMapping = (CsvFieldMapping)fieldMappings.get(mappedHeader);
                            for (Integer index : indexes) {
                                String mappedValue;
                                if (index >= line.size() || line.get(index) == null || "<<blank>>".equals(mappedValue = configBean.getValueMappingForHeader(mappedHeader, (String)line.get(index))) || !StringUtils.isNotEmpty((CharSequence)mappedValue)) continue;
                                csvLine.add(fieldMapping, mappedValue);
                            }
                        }
                        lineHandler.handleLink(csvLine);
                    }
                }
                catch (EOFException line) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static String msg(String i18nKey, Object ... params) {
        I18nHelper i18nHelper = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        return i18nHelper.getText(i18nKey, (Object)params);
    }

    /*
     * Exception decompiling
     */
    public ErrorCollection accessCsvFile(CsvReaderAccessor accessor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeReader(CsvListReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.warn((Object)"Cannot close CSV file", (Throwable)e);
            }
        }
    }

    public boolean hasHeaderMultipleColumns(String header) {
        return this.headerWithIndexes.containsKey((Object)header) && this.headerWithIndexes.get((Object)header).size() > 1;
    }

    public Iterable<String> getValuesFor(String header) {
        Collection indexes = this.headerWithIndexes.get((Object)header);
        return Iterables.filter((Iterable)Iterables.transform((Iterable)indexes, (Function)new Function<Integer, String>(){

            public String apply(Integer index) {
                return index < CsvFile.this.firstRow.size() ? (String)CsvFile.this.firstRow.get(index) : null;
            }
        }), (Predicate)Predicates.notNull());
    }

    public String[] getRawHeader() {
        return this.rawHeader;
    }

    private InputStream getJiraFileInputStream(File file) throws IOException {
        Constructor<?>[] constructors;
        Class<?> streamClass;
        try {
            streamClass = this.getClass().getClassLoader().loadClass("com.atlassian.jira.util.xml.JiraFileInputStream");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find JiraFileInputStream class", e);
        }
        for (Constructor<?> constructor : constructors = streamClass.getConstructors()) {
            if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].isAssignableFrom(File.class)) {
                return this.create(constructor, file);
            }
            if (constructor.getParameterTypes().length != 2 || !constructor.getParameterTypes()[0].isAssignableFrom(File.class) || !constructor.getParameterTypes()[1].isAssignableFrom(String.class)) continue;
            return this.create(constructor, file, null);
        }
        throw new IllegalStateException("Cannot create JiraFileInputStream, no suitable constructor found.");
    }

    private InputStream create(Constructor<?> constructor, Object ... params) throws IOException {
        try {
            return (InputStream)constructor.newInstance(params);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot create JiraFileInputStream", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot create JiraFileInputStream", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw new IOException("Cannot read the specified file", e);
            }
            throw new IllegalStateException("Cannot create JiraFileInputStream", e);
        }
    }

    static /* synthetic */ String[] access$302(CsvFile x0, String[] x1) {
        x0.rawHeader = x1;
        return x1;
    }

    private static interface CsvReaderAccessor {
        public void handleReader(CsvListReader var1, SimpleErrorCollection var2) throws IOException;
    }
}

