/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv;

import com.google.common.base.Predicate;
import java.util.Stack;
import javax.annotation.Nullable;

public class CsvFieldNameValidator {
    public static Predicate<String> HEADER_NAME_VALIDATOR = new Predicate<String>(){

        public boolean apply(@Nullable String value) {
            if (value == null) {
                return true;
            }
            Stack<Character> bracketStack = new Stack<Character>();
            block5: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '(': 
                    case '[': {
                        bracketStack.push(Character.valueOf(c));
                        continue block5;
                    }
                    case ')': {
                        if (!bracketStack.isEmpty() && '(' == ((Character)bracketStack.peek()).charValue()) {
                            bracketStack.pop();
                            continue block5;
                        }
                        return false;
                    }
                    case ']': {
                        if (!bracketStack.isEmpty() && '[' == ((Character)bracketStack.peek()).charValue()) {
                            bracketStack.pop();
                            continue block5;
                        }
                        return false;
                    }
                }
            }
            return bracketStack.isEmpty();
        }
    };
}

