/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDataBean;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.DefaultExternalCustomFieldValueMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.DefaultExternalIssueMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.DefaultExternalProjectMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCommentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalComponentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCustomFieldValueMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalIssueMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalLabelsMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalProjectMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalVersionMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalWatchersMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalWorklogMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.FullNameUserMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.SimpleCommentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.SimpleCustomFieldVersionMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.SimpleExternalComponentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.SimpleExternalLabelsMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.SimpleExternalVersionMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.SimpleExternalWatchersMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.SimpleExternalWorklogMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.SimpleTimeEstimateConverter;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.TimeEstimateConverter;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.util.DateFieldFormat;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;

public class CsvDataBeanBuilder {
    private final GoodCsvConfigBean configBean;
    private final JiraHome jiraHome;
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final ExternalVersionMapper affectedVersionMapper = new SimpleExternalVersionMapper("versions");
    private final ExternalVersionMapper fixedVersionMapper = new SimpleExternalVersionMapper("fixVersions");
    private List<ExternalUserMapper> userMappers = Lists.newArrayList((Object[])new ExternalUserMapper[]{new FullNameUserMapper(CsvFieldMapping.field("reporter")), new FullNameUserMapper(CsvFieldMapping.field("assignee"))});
    private final ExternalComponentMapper componentMapper = new SimpleExternalComponentMapper();
    private final ExternalLabelsMapper labelsMapper = new SimpleExternalLabelsMapper();
    private final ExternalWatchersMapper externalWatchersMapper = new SimpleExternalWatchersMapper();
    private final ExternalVersionMapper customFieldVersionMapper;
    private final ExternalIssueMapper issueMapper;
    private ExternalCommentMapper commentMapper;
    private final ExternalCustomFieldValueMapper customFieldValueMapper;
    private final ExternalWorklogMapper externalWorklogMapper;
    private ExternalProjectMapper projectMapper = new DefaultExternalProjectMapper();

    public CsvDataBeanBuilder(GoodCsvConfigBean configBean, JiraHome jiraHome, IssueManager issueManager, AttachmentManager attachmentManager, DateFieldFormat formatter, DateTimeFormatter dateTimeFormatter, IssueLinkTypeManager issueLinkTypeManager, CustomFieldManager customFieldManager) throws ConfigurationException {
        this.configBean = configBean;
        this.jiraHome = jiraHome;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueMapper = new DefaultExternalIssueMapper(new SimpleTimeEstimateConverter(), configBean);
        this.commentMapper = new SimpleCommentMapper(configBean);
        this.customFieldVersionMapper = new SimpleCustomFieldVersionMapper(customFieldManager);
        this.customFieldValueMapper = new DefaultExternalCustomFieldValueMapper(configBean, formatter, dateTimeFormatter, customFieldManager);
        this.externalWorklogMapper = new SimpleExternalWorklogMapper(configBean);
    }

    public CsvDataBean build() {
        return new CsvDataBean(this.configBean, this.affectedVersionMapper, this.fixedVersionMapper, this.customFieldVersionMapper, this.userMappers, this.componentMapper, this.projectMapper, this.issueMapper, this.commentMapper, this.customFieldValueMapper, this.labelsMapper, this.externalWatchersMapper, this.externalWorklogMapper, this.jiraHome, this.issueManager, this.attachmentManager, this.issueLinkTypeManager);
    }

    public CsvDataBeanBuilder projectMapper(ExternalProjectMapper projectMapper) {
        this.projectMapper = projectMapper;
        return this;
    }

    public CsvDataBeanBuilder userMappers(List<ExternalUserMapper> customUserMappers) {
        this.userMappers = customUserMappers;
        return this;
    }

    public CsvDataBeanBuilder commentMapper(ExternalCommentMapper customCommentMapper) {
        this.commentMapper = customCommentMapper;
        return this;
    }

    public CsvDataBeanBuilder timeEstimateConverter(TimeEstimateConverter customTimeEstimateConverter) {
        this.issueMapper.setTimeTrackingConverter(customTimeEstimateConverter);
        return this;
    }
}

