/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AvailableJiraFieldMappings {
    public static final String ISSUE_LINK_FIELD_PREFIX = "link-";
    private final Map<String, String> PROJECT = this.translateValues((Map<String, String>)ImmutableMap.builder().put((Object)"project.name", (Object)"jira-importer-plugin.csv.project.name").put((Object)"project.key", (Object)"jira-importer-plugin.csv.project.key").put((Object)"project.lead", (Object)"jira-importer-plugin.csv.project.lead").put((Object)"project.description", (Object)"jira-importer-plugin.csv.project.description").put((Object)"project.url", (Object)"jira-importer-plugin.csv.project.url").build());
    private final Map<String, String> TIME_TRACKING = this.translateValues((Map<String, String>)ImmutableMap.builder().put((Object)"timeoriginalestimate", (Object)"jira-importer-plugin.csv.original.estimate.desc").put((Object)"timeestimate", (Object)"jira-importer-plugin.csv.remaining.estimate.desc").put((Object)"timespent", (Object)"jira-importer-plugin.csv.time.spent.desc").build());
    private final Map<String, String> ISSUE_MULTIPLE = this.translateValues((Map<String, String>)ImmutableMap.builder().put((Object)"attachment", (Object)"issue.field.attachment").put((Object)"comment", (Object)"issue.field.comment.body").put((Object)"labels", (Object)"issue.field.labels").put((Object)"watcher", (Object)"issue.field.watch").put((Object)"issuekey", (Object)"jira-importer-plugin.csv.issue.key").build());
    private final Map<String, String> ISSUE_SINGLE = this.translateValues((Map<String, String>)ImmutableMap.builder().put((Object)"assignee", (Object)"issue.field.assignee").put((Object)"created", (Object)"issue.field.date.created").put((Object)"updated", (Object)"issue.field.date.modified").put((Object)"description", (Object)"issue.field.description").put((Object)"duedate", (Object)"issue.field.duedate").put((Object)"environment", (Object)"issue.field.environment").put((Object)"issuetype", (Object)"issue.field.issuetype").put((Object)"priority", (Object)"issue.field.priority").put((Object)"reporter", (Object)"issue.field.reporter").put((Object)"resolution", (Object)"issue.field.resolution").put((Object)"resolutiondate", (Object)"issue.field.date.resolved").put((Object)"status", (Object)"issue.field.status").put((Object)"summary", (Object)"issue.field.summary").put((Object)"votes", (Object)"issue.field.vote").build());
    private final Map<String, String> VERSIONS_COMPONENTS = this.translateValues((Map<String, String>)ImmutableMap.builder().put((Object)"components", (Object)"issue.field.component").put((Object)"versions", (Object)"issue.field.version").put((Object)"fixVersions", (Object)"issue.field.fixversion").build());
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final CompatibilityBridgeUtils bridgeUtils;

    @Autowired
    public AvailableJiraFieldMappings(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, IssueLinkTypeManager issueLinkTypeManager, CompatibilityBridgeUtils bridgeUtils) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.bridgeUtils = bridgeUtils;
    }

    public ImmutableMap<String, Map<String, String>> getAvailableMappingsSingleField(boolean includeProjectFields) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (includeProjectFields) {
            HashMap projectFields = Maps.newHashMap(this.PROJECT);
            if (this.bridgeUtils.rolesEnabled()) {
                projectFields.put("project.type", this.getText("jira-importer-plugin.csv.project.type"));
            }
            builder.put((Object)this.getText("admin.csv.import.mappings.project.fields.header"), (Object)projectFields);
        }
        builder.put((Object)this.getText("admin.csv.import.mappings.version.comp.header"), this.VERSIONS_COMPONENTS);
        ImmutableMap.Builder issueFields = ImmutableMap.builder().putAll(this.ISSUE_SINGLE);
        issueFields.putAll(this.ISSUE_MULTIPLE);
        if (this.isTimetrackingEnabled()) {
            issueFields.putAll(this.TIME_TRACKING);
            issueFields.put((Object)"worklog", (Object)this.getText("jira-importer-plugin.csv.worklog.desc"));
        }
        builder.put((Object)this.getText("admin.csv.import.mappings.issue.fields.header"), (Object)issueFields.build());
        if (this.areSubtasksEnabled() || this.isLinkingEnabled()) {
            ImmutableMap.Builder linking = ImmutableMap.builder();
            linking.put((Object)"issue-id", (Object)this.getText("jira-importer-plugin.csv.mappings.subtasks.issueid"));
            if (this.areSubtasksEnabled()) {
                linking.put((Object)"subtask-parent-id", (Object)this.getText("jira-importer-plugin.csv.mappings.subtasks.parentid"));
            }
            if (this.isLinkingEnabled()) {
                linking.putAll(this.getLinks());
            }
            builder.put((Object)this.getText("jira-importer-plugin.csv.mappings.subtasks-and-linking"), (Object)linking.build());
        }
        builder.put((Object)this.getText("admin.csv.import.mappings.custom.fields.header"), Collections.singletonMap("newCustomField", this.getText("admin.csv.import.mappings.custom.fields.new")));
        return builder.build();
    }

    public ImmutableMap<String, Map<String, String>> getAvailableMappingsMultipleField() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.getText("admin.csv.import.mappings.project.fields.header"), this.VERSIONS_COMPONENTS);
        ImmutableMap.Builder issueFields = ImmutableMap.builder();
        issueFields.putAll(this.ISSUE_MULTIPLE);
        if (this.isTimetrackingEnabled()) {
            issueFields.put((Object)"worklog", (Object)this.getText("jira-importer-plugin.csv.worklog.desc"));
        }
        builder.put((Object)this.getText("admin.csv.import.mappings.issue.fields.header"), (Object)issueFields.build());
        if (this.isLinkingEnabled()) {
            ImmutableMap.Builder linking = ImmutableMap.builder();
            linking.put((Object)"issue-id", (Object)this.getText("jira-importer-plugin.csv.mappings.subtasks.issueid"));
            if (this.isLinkingEnabled()) {
                linking.putAll(this.getLinks());
            }
            builder.put((Object)this.getText("jira-importer-plugin.csv.mappings.subtasks-and-linking"), (Object)linking.build());
        }
        builder.put((Object)this.getText("admin.csv.import.mappings.custom.fields.header"), Collections.singletonMap("newCustomField", this.getText("admin.csv.import.mappings.custom.fields.new")));
        return builder.build();
    }

    public Map<String, String> getLinks() {
        ImmutableMap.Builder links = ImmutableMap.builder();
        for (IssueLinkType linkType : this.issueLinkTypeManager.getIssueLinkTypes()) {
            String linkDisplayName = String.format("Link \"%s\"", linkType.getName());
            links.put((Object)(ISSUE_LINK_FIELD_PREFIX + linkType.getId()), (Object)linkDisplayName);
        }
        return links.build();
    }

    private boolean isLinkingEnabled() {
        return this.applicationProperties.getOption("jira.option.issuelinking");
    }

    private boolean isTimetrackingEnabled() {
        return this.applicationProperties.getOption("jira.option.timetracking");
    }

    private boolean areSubtasksEnabled() {
        return this.applicationProperties.getOption("jira.option.allowsubtasks");
    }

    private Map<String, String> translateValues(Map<String, String> map) {
        return Maps.transformValues(map, (Function)new Function<String, String>(){

            public String apply(String input) {
                return AvailableJiraFieldMappings.this.getText(input);
            }
        });
    }

    private String getText(String key) {
        return this.authenticationContext.getI18nHelper().getText(key);
    }
}

