/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.config;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class ValueMappingHelperImpl
implements ValueMappingHelper {
    private static final Logger log = Logger.getLogger(ValueMappingHelperImpl.class);
    private final Set<String> fieldsForValueMapping = Sets.newLinkedHashSet();
    private final MultiKeyMap valueMapping = new MultiKeyMap();
    private Map<String, Collection<String>> distinctValuesCache;
    private MultiKeyMap valueMappingFieldNames;
    protected final Map<String, ValueMappingDefinition> mappingDefinitions = Maps.newLinkedHashMap();

    @Deprecated
    public ValueMappingHelperImpl(WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, ValueMappingDefinitionsFactory valueMappingDefinitionsFactory, ConstantsManager constantsManager) {
        this(valueMappingDefinitionsFactory);
    }

    public ValueMappingHelperImpl(ValueMappingDefinitionsFactory valueMappingDefinitionsFactory) {
        for (ValueMappingDefinition mappingDefinition : valueMappingDefinitionsFactory.createMappingDefinitions(this)) {
            this.mappingDefinitions.put(mappingDefinition.getExternalFieldId(), mappingDefinition);
        }
        this.initializeDefaultValues();
        this.initializeFieldsForValueMapping();
    }

    @Override
    public void initDistinctValuesCache() {
        this.distinctValuesCache = this.getDistinctValues(this.getAvailableFields());
    }

    @Override
    public Collection<ValueMappingDefinition> getAvailableFields() {
        return this.mappingDefinitions.values();
    }

    @Override
    public Long getValueCountForField(String fieldName) {
        Collection<String> distinctValues = this.getDistinctValuesForField(fieldName);
        if (distinctValues != null) {
            return distinctValues.size();
        }
        return null;
    }

    @Override
    public boolean isMapValueForField(String fieldName) {
        return this.fieldsForValueMapping.contains(fieldName);
    }

    private void initializeFieldsForValueMapping() {
        this.fieldsForValueMapping.clear();
        for (ValueMappingDefinition definition : this.getAvailableFields()) {
            if (!definition.isMandatory()) continue;
            this.fieldsForValueMapping.add(definition.getExternalFieldId());
        }
    }

    @Override
    public void populateFieldForValueMappings(Map actionParams) {
        this.initializeFieldsForValueMapping();
        Collection<ValueMappingDefinition> fields = this.getAvailableFields();
        for (ValueMappingDefinition definition : fields) {
            String fieldName = definition.getExternalFieldId();
            String keyMapping = ParameterUtils.getStringParam((Map)actionParams, (String)fieldName);
            if (!BooleanUtils.toBoolean((String)keyMapping)) continue;
            this.fieldsForValueMapping.add(fieldName);
        }
    }

    @Override
    public Collection<String> getFieldsForValueMapping() {
        return this.fieldsForValueMapping;
    }

    @Override
    public Collection<String> getDistinctValuesForField(String fieldName) {
        return this.distinctValuesCache.get(fieldName);
    }

    @Override
    public String getValueMappingFieldName(String fieldName, String value) {
        if (this.valueMappingFieldNames == null) {
            this.valueMappingFieldNames = new MultiKeyMap();
            for (ValueMappingDefinition fieldForMapping : this.getAvailableFields()) {
                String fieldNameForMapping = fieldForMapping.getExternalFieldId();
                Collection<String> distinctValues = this.getDistinctValuesForField(fieldNameForMapping);
                if (distinctValues == null) continue;
                int idx = 0;
                for (String distinctValue : distinctValues) {
                    this.valueMappingFieldNames.put((Object)fieldNameForMapping, (Object)distinctValue, (Object)("value_mapping_for_" + fieldNameForMapping + "_" + idx++));
                }
            }
        }
        return (String)this.valueMappingFieldNames.get((Object)fieldName, (Object)value);
    }

    @Override
    public String getValueMapping(String fieldName, String value) {
        return (String)this.valueMapping.get((Object)fieldName, (Object)value);
    }

    @Override
    public void populateValueMappings(Map actionParams) {
        this.valueMapping.clear();
        for (String fieldNameForMapping : this.getFieldsForValueMapping()) {
            Collection<String> distinctValues = this.getDistinctValuesForField(fieldNameForMapping);
            if (distinctValues == null) continue;
            for (String distinctValue : distinctValues) {
                String htmlFieldName = this.getValueMappingFieldName(fieldNameForMapping, distinctValue);
                String mappedValue = ParameterUtils.getStringParam((Map)actionParams, (String)htmlFieldName);
                this.valueMapping.put((Object)fieldNameForMapping, (Object)distinctValue, (Object)mappedValue);
            }
        }
    }

    @Override
    @Nullable
    public Collection<ValueMappingEntry> getTargetValues(String fieldName) {
        ValueMappingDefinition mappingDefinition = this.mappingDefinitions.get(fieldName);
        if (mappingDefinition != null) {
            return mappingDefinition.getTargetValues();
        }
        return null;
    }

    @Override
    @Nullable
    public ValueMappingDefinition getValueMappingDefinition(String fieldName) {
        return this.mappingDefinitions.get(fieldName);
    }

    private void initializeDefaultValues() {
        Collection<ValueMappingDefinition> definitions = this.getAvailableFields();
        for (ValueMappingDefinition definition : definitions) {
            String fieldName = definition.getExternalFieldId();
            Collection<ValueMappingEntry> defaultValues = definition.getDefaultValues();
            for (ValueMappingEntry defaultValue : defaultValues) {
                this.valueMapping.put((Object)fieldName, (Object)defaultValue.getName(), (Object)defaultValue.getId());
            }
        }
    }

    @Override
    public void copyFromProperties(Map<String, Object> configFile) {
        Collection<ValueMappingDefinition> fieldsAvailableForMapValues = this.getAvailableFields();
        Map config = (Map)configFile.get("value");
        for (ValueMappingDefinition valueMappingDefinition : fieldsAvailableForMapValues) {
            String fieldName = valueMappingDefinition.getExternalFieldId();
            Map valueConfig = (Map)config.get(fieldName);
            if (valueConfig == null) continue;
            for (Map.Entry entry : valueConfig.entrySet()) {
                this.fieldsForValueMapping.add(fieldName);
                String mappedValue = (String)entry.getValue();
                this.valueMapping.put((Object)fieldName, entry.getKey(), (Object)("".equals(mappedValue) ? "<<blank>>" : mappedValue));
            }
        }
    }

    @Override
    public void copyToNewProperties(Map<String, Object> configFile) {
        HashMap configCopy = Maps.newHashMap();
        configFile.put("value", configCopy);
        for (Object vm : this.valueMapping.entrySet()) {
            Map.Entry entry = (Map.Entry)vm;
            MultiKey key = (MultiKey)entry.getKey();
            String targetMapping = (String)entry.getValue();
            if (!StringUtils.isNotBlank((String)targetMapping)) continue;
            if (!configCopy.containsKey(key.getKey(0))) {
                configCopy.put(key.getKey(0).toString(), Maps.newHashMap());
            }
            ((Map)configCopy.get(key.getKey(0))).put(key.getKey(1).toString(), "<<blank>>".equals(targetMapping) ? "" : targetMapping);
        }
    }

    @Override
    public String getValueMappingForImport(String fieldName, String value) {
        if (!this.isMapValueForField(fieldName)) {
            return value;
        }
        String mappedValue = this.getValueMapping(fieldName, value);
        if (StringUtils.isNotBlank((String)mappedValue)) {
            if (!"<<blank>>".equals(mappedValue)) {
                return mappedValue;
            }
            return "";
        }
        return value;
    }

    @Override
    public Collection<String> getAvailableWorkflowSchemes() {
        WorkflowSchemeManager schemeManager = ComponentAccessor.getWorkflowSchemeManager();
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)schemeManager.getSchemeObjects(), (Function)new Function<Scheme, String>(){

            public String apply(Scheme input) {
                return input.getName();
            }
        }));
    }

    @Override
    public String getDefaultWorkflowName() {
        return "[none-default-workflow]";
    }

    @Override
    public String getWorkflowSchemeName() {
        return "[none-default-workflow]";
    }

    @Override
    public JiraWorkflow getSelectedWorkflow() {
        return null;
    }

    @Override
    public boolean isWorkflowSchemeDefined() {
        return false;
    }

    @Override
    public JiraWorkflow getWorkflowForBugs(GenericValue scheme) {
        return null;
    }

    private Map<String, Collection<String>> getDistinctValues(Collection<ValueMappingDefinition> availableFields) {
        HashMap distinctValues = Maps.newHashMap();
        for (ValueMappingDefinition valueMappingDefinition : availableFields) {
            distinctValues.put(valueMappingDefinition.getExternalFieldId(), valueMappingDefinition.getDistinctValues());
        }
        return distinctValues;
    }
}

