/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.config;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public abstract class AbstractValueMappingDefinition
implements ValueMappingDefinition {
    protected final JdbcConnection jdbcConnection;
    protected final JiraAuthenticationContext authenticationContext;

    protected AbstractValueMappingDefinition(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext) {
        this.jdbcConnection = jdbcConnection;
        this.authenticationContext = authenticationContext;
    }

    protected I18nHelper getI18n() {
        return this.authenticationContext.getI18nHelper();
    }

    @Override
    @Nullable
    public String getJiraFieldId() {
        return null;
    }

    @Override
    @Nullable
    public Collection<ValueMappingEntry> getTargetValues() {
        return null;
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return Collections.emptyList();
    }

    @Override
    public boolean canBeBlank() {
        return true;
    }

    @Override
    public boolean canBeImportedAsIs() {
        return true;
    }

    @Override
    public boolean canBeCustom() {
        return true;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    public static class IssueConstantToValueMapping
    implements Function<IssueConstant, ValueMappingEntry> {
        public ValueMappingEntry apply(IssueConstant from) {
            return new ValueMappingEntry(from.getName(), from.getId());
        }
    }
}

