/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.web;

import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.extensions.ImporterController2;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.ValidationCallable;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.ValidableJiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterExecutionContext;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BulkCreateValidationPage
extends ImporterProcessSupport {
    private final TaskManager taskManager;

    public BulkCreateValidationPage(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor, TaskManager taskManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.taskManager = taskManager;
    }

    @Override
    @Nullable
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.bc.validation.title");
    }

    @Override
    public int getCurrentStep() {
        return 4;
    }

    public String doViewLogs() throws Exception {
        return this.doExecute();
    }

    @Override
    protected String doExecute() throws Exception {
        if (!this.canSeePage()) {
            return "denied";
        }
        JiraDataImporter importer = this.getImporter();
        if (importer == null) {
            return "restartimporterneeded";
        }
        if (this.isNextClicked() || this.isPreviousClicked() || this.isFinishClicked()) {
            importer.abort(this.getLoggedInApplicationUser().getName());
        }
        if (importer.getStats() != null) {
            if (!this.isPreviousClicked() && importer.isRunning()) {
                return "input";
            }
            if (this.isFinishClicked()) {
                return super.doExecute();
            }
            if (this.isPreviousClicked()) {
                return this.getRedirect(this.getRedirectURL("BulkCreateValueMappingPage!default.jspa"));
            }
            return "input";
        }
        return "restartimporterneeded";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresXsrfCheck
    public String doValidate() {
        ImporterController2 controller = this.getController2();
        ImportProcessBean bean = controller != null ? controller.getImportProcessBeanFromSession() : null;
        ValidableJiraDataImporter importer = controller.getImporter();
        if (importer == null || bean == null) {
            return "restartimporterneeded";
        }
        ValidableJiraDataImporter validableJiraDataImporter = importer;
        synchronized (validableJiraDataImporter) {
            block11: {
                if (!importer.isRunning()) {
                    ImportLogger importerLog;
                    block10: {
                        importer.initializeLog();
                        try {
                            ImportDataBean dataBean = controller.createDataBean();
                            importer.setDataBean(dataBean);
                        }
                        catch (Exception e) {
                            importerLog = importer.getLog();
                            if (importerLog == null) break block10;
                            importerLog.fail(e, "Failed to create data bean", new Object[0]);
                        }
                    }
                    if (importer.getDataBean() != null) {
                        try {
                            this.taskManager.submitTask((Callable)new ValidationCallable(importer, new ImporterExecutionContext(controller.getId(), this.getLoggedInApplicationUser())), "JIRA Importers Plugin Main Import Task", (TaskContext)new EmptyTaskContext());
                        }
                        catch (Exception e) {
                            importerLog = importer.getLog();
                            if (importerLog == null) break block11;
                            importerLog.fail(e, "Failed to start import", new Object[0]);
                        }
                    }
                }
            }
        }
        return this.redirectToViewLogs();
    }

    private String redirectToViewLogs() {
        return this.getRedirect(this.getRedirectURL("BulkCreateValidationPage!viewLogs.jspa"));
    }

    @Override
    @Nonnull
    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-plugin:validateResources");
    }

    @Nullable
    public JiraDataImporter getImporter() {
        ImporterController controller = this.getController();
        return controller != null ? controller.getImporter() : null;
    }

    private static final class EmptyTaskContext
    implements TaskContext {
        private EmptyTaskContext() {
        }

        public String buildProgressURL(Long taskId) {
            return null;
        }
    }
}

