/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.extensions.ImporterController2;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.FieldMappings;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.VisibleFieldsHelper;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.csv.AbstractCsvFieldMappingPage;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import webwork.action.Action;

public class BulkCreateFieldMapping
extends AbstractCsvFieldMappingPage {
    private final ProjectManager projectManager;
    private final VisibleFieldsHelper visibleFieldsHelper;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final ApplicationProperties applicationProperties;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private Map<String, Map<String, String>> preparedFieldOptions;

    public BulkCreateFieldMapping(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor, IssueTypeSchemeManager issueTypeSchemeManager, ProjectManager projectManager, CustomFieldManager customFieldManager, IssueFactory issueFactory, @ComponentImport FieldScreenRendererFactory fieldScreenRendererFactory, EventPublisher eventPublisher, IssueLinkTypeManager issueLinkTypeManager, ApplicationProperties applicationProperties) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, customFieldManager, eventPublisher);
        this.projectManager = projectManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.applicationProperties = applicationProperties;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.visibleFieldsHelper = new VisibleFieldsHelper(issueTypeSchemeManager, issueFactory, fieldScreenRendererFactory);
    }

    @Override
    @Nullable
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.bc.field.mapping.title");
    }

    @Override
    public ImmutableSet<CustomField> getCustomFields() {
        Iterable customFields = Iterables.transform(this.getVisibleFields(), (Function)new Function<OrderableField, CustomField>(){

            public CustomField apply(OrderableField orderableField) {
                if (orderableField instanceof CustomField) {
                    return (CustomField)orderableField;
                }
                return null;
            }
        });
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)customFields, (Predicate)Predicates.notNull()));
    }

    @Override
    protected Map<String, Map<String, String>> getMappingsForSingle() {
        if (this.preparedFieldOptions == null) {
            this.preparedFieldOptions = this.prepareFields();
        }
        return this.preparedFieldOptions;
    }

    @Override
    protected Map<String, Map<String, String>> getMappingsForMultiple() {
        return this.getMappingsForSingle();
    }

    public Map<String, Map<String, String>> prepareFields() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        HashSet visibleFields = Sets.newHashSet(this.getVisibleFields());
        OrderableField timeTrackingField = this.getTimeTrackingField(visibleFields);
        OrderableField worklogField = this.getWorklogField(visibleFields);
        if (this.getApplicationProperties().getOption("jira.option.timetracking")) {
            if (timeTrackingField != null) {
                mapBuilder.put((Object)"timeoriginalestimate", (Object)this.getText("jira-importer-plugin.bc.field.mapping.original.estimate.desc"));
            }
            if (timeTrackingField != null && !this.getApplicationProperties().getOption("jira.timetracking.estimates.legacy.behaviour") || worklogField != null && this.hasProjectPermission(20, this.getProject())) {
                mapBuilder.put((Object)"timeestimate", (Object)this.getText("jira-importer-plugin.bc.field.mapping.remaining.estimate.desc"));
            }
            if (worklogField != null && this.hasProjectPermission(20, this.getProject())) {
                mapBuilder.put((Object)"timespent", (Object)this.getText("jira-importer-plugin.bc.field.mapping.time.spent.desc"));
            }
        }
        Map<String, String> subtasksAndLinkingSection = this.getSubtasksAndLinkingSection(visibleFields);
        for (OrderableField orderableField : visibleFields) {
            if (orderableField instanceof CustomField || FieldMappings.isBlacklisted(orderableField.getId())) continue;
            mapBuilder.put((Object)orderableField.getId(), (Object)orderableField.getName());
        }
        ImmutableMap fields = mapBuilder.build();
        if (subtasksAndLinkingSection.size() > 0) {
            return ImmutableMap.of((Object)this.getText("jira-importer-plugin.bc.field.mapping.jira.fields"), (Object)fields, (Object)this.getText("jira-importer-plugin.csv.mappings.subtasks-and-linking"), subtasksAndLinkingSection);
        }
        return ImmutableMap.of((Object)this.getText("jira-importer-plugin.bc.field.mapping.jira.fields"), (Object)fields);
    }

    private Map<String, String> getSubtasksAndLinkingSection(Set<OrderableField> availableFields) {
        OrderableField linksField = this.getLinksField(availableFields);
        if (!this.areSubtasksEnabled() && linksField == null) {
            return ImmutableMap.of();
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("issue-id", this.getText("jira-importer-plugin.csv.mappings.subtasks.issueid"));
        if (this.areSubtasksEnabled()) {
            map.put("subtask-parent-id", this.getText("jira-importer-plugin.csv.mappings.subtasks.parentid"));
        }
        if (linksField != null) {
            availableFields.remove(linksField);
            map.putAll(this.getLinks());
        }
        return map;
    }

    private boolean areSubtasksEnabled() {
        return this.applicationProperties.getOption("jira.option.allowsubtasks") && Iterables.any((Iterable)this.issueTypeSchemeManager.getIssueTypesForProject(this.getProject()), (Predicate)new Predicate<IssueType>(){

            public boolean apply(IssueType input) {
                return input.isSubTask();
            }
        });
    }

    public Map<String, String> getLinks() {
        ImmutableMap.Builder links = ImmutableMap.builder();
        for (IssueLinkType linkType : this.issueLinkTypeManager.getIssueLinkTypes()) {
            String linkDisplayName = String.format("Link \"%s\"", linkType.getName());
            links.put((Object)("link-" + linkType.getId()), (Object)linkDisplayName);
        }
        return links.build();
    }

    private OrderableField getLinksField(Set<OrderableField> visibleFields) {
        return (OrderableField)Iterables.getFirst((Iterable)Iterables.filter(visibleFields, (Predicate)new Predicate<OrderableField>(){

            public boolean apply(@Nullable OrderableField input) {
                return input != null && "issuelinks".equals(input.getId());
            }
        }), null);
    }

    private OrderableField getTimeTrackingField(Set<OrderableField> visibleFields) {
        return (OrderableField)Iterables.getFirst((Iterable)Iterables.filter(visibleFields, (Predicate)new Predicate<OrderableField>(){

            public boolean apply(@Nullable OrderableField input) {
                return input != null && "timetracking".equals(input.getId());
            }
        }), null);
    }

    private OrderableField getWorklogField(Set<OrderableField> visibleFields) {
        return (OrderableField)Iterables.getFirst((Iterable)Iterables.filter(visibleFields, (Predicate)new Predicate<OrderableField>(){

            public boolean apply(@Nullable OrderableField input) {
                return input != null && "worklog".equals(input.getId());
            }
        }), null);
    }

    private Set<OrderableField> getVisibleFields() {
        return this.visibleFieldsHelper.getVisibleFields(this.getProject(), (Action)this, ComponentAccessor.getJiraAuthenticationContext().getUser());
    }

    @Override
    @Nonnull
    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-plugin:csvFieldMappingsPage");
    }

    @Override
    public GoodCsvConfigBean getConfigBean() {
        ImporterController2 controller2 = this.getController2();
        if (controller2 != null) {
            ImportProcessBean processBean = controller2.getImportProcessBeanFromSession();
            return processBean != null ? (GoodCsvConfigBean)processBean.getConfigBean() : null;
        }
        return null;
    }

    private Project getProject() {
        GoodCsvConfigBean configBean = this.getConfigBean();
        return this.projectManager.getProjectObjByKey(configBean.getProjectKey(""));
    }
}

