/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.engine;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.engine.CreatedIssueInfo;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkImportUtils {
    private final IssueLinkService issueLinkService;
    private final IssueService issueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueLinkTypeManager linkTypeManager;
    private final IssueFactory issueFactory;
    private final CompatibilityBridgeUtils bridgeUtils;

    @Autowired
    public LinkImportUtils(@ComponentImport IssueLinkService issueLinkService, @ComponentImport IssueService issueService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport IssueLinkTypeManager linkTypeManager, @ComponentImport IssueFactory issueFactory, CompatibilityBridgeUtils bridgeUtils) {
        this.issueLinkService = issueLinkService;
        this.issueService = issueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.linkTypeManager = linkTypeManager;
        this.issueFactory = issueFactory;
        this.bridgeUtils = bridgeUtils;
    }

    public boolean handleIssueLink(ExternalLink externalLink, List<CreatedIssueInfo> createdIssueInfos, Project project, boolean isValidation, ImportLogger log) {
        IssueLinkService.AddIssueLinkValidationResult validationResult;
        String destinationKey;
        if (externalLink.isSubtask()) {
            return true;
        }
        Either<Issue, String> sourceIssue = this.getForExternalId(externalLink.getSourceId(), createdIssueInfos);
        Either<Issue, String> destinationIssue = this.getForIssueKeyOrExternalId(externalLink.getDestinationId(), createdIssueInfos);
        if (sourceIssue == null || destinationIssue == null || !isValidation && (sourceIssue.isRight() || destinationIssue.isRight())) {
            log.warn("Issue link '%s' between '%s' and '%s' cannot be created - at least one of the issues couldn't be found.", externalLink.getName(), externalLink.getSourceId(), externalLink.getDestinationId());
            return false;
        }
        IssueLinkType linkType = this.getLinkTypeFromName(externalLink.getName());
        if (linkType == null) {
            log.warn("Issue link '%s' no longer exists!", externalLink.getName());
            return false;
        }
        if (sourceIssue.isRight() && destinationIssue.isRight() && ((String)sourceIssue.right().get()).equals(destinationIssue.right().get())) {
            log.warn("Issue link '%s' for issue id '%s' cannot be created, because it points to itself", externalLink.getName(), externalLink.getSourceId());
            return false;
        }
        if (sourceIssue.isLeft()) {
            destinationKey = destinationIssue.isLeft() ? ((Issue)destinationIssue.left().get()).getKey() : (String)destinationIssue.right().get();
            validationResult = this.validateIssueLink((Issue)sourceIssue.left().get(), linkType.getOutward(), destinationKey);
        } else if (destinationIssue.isLeft()) {
            destinationKey = (String)sourceIssue.right().get();
            validationResult = this.validateIssueLink((Issue)destinationIssue.left().get(), linkType.getInward(), destinationKey);
        } else {
            CreatedIssueInfo issueInfo = this.getIssueInfo((String)sourceIssue.right().get(), createdIssueInfos);
            Issue tempIssue = this.createTempIssue(issueInfo.getIssueType(), project);
            destinationKey = (String)destinationIssue.right().get();
            validationResult = this.validateIssueLink(tempIssue, linkType.getInward(), destinationKey);
        }
        if (isValidation) {
            if (!validationResult.isValid()) {
                Collection errorMessages = validationResult.getErrorCollection().getErrorMessages();
                String expectedMessage = this.jiraAuthenticationContext.getI18nHelper().getText("issuelinking.service.error.linked.issue.doesnt.exist", destinationKey);
                errorMessages.remove(expectedMessage);
                this.printErrors(errorMessages, log);
            }
        } else if (validationResult.isValid()) {
            this.bridgeUtils.addIssueLinks(this.issueLinkService, this.jiraAuthenticationContext.getUser(), validationResult);
        } else {
            this.printErrors(validationResult.getErrorCollection().getErrorMessages(), log);
        }
        return true;
    }

    private IssueLinkService.AddIssueLinkValidationResult validateIssueLink(Issue sourceIssue, String linkDirection, String issueKey) {
        return this.bridgeUtils.validateAddIssueLinks(this.issueLinkService, this.jiraAuthenticationContext.getUser(), sourceIssue, linkDirection, (List<String>)ImmutableList.of((Object)issueKey));
    }

    private Issue createTempIssue(IssueType issueType, Project project) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectObject(project);
        issue.setIssueTypeObject(issueType);
        return issue;
    }

    private void printErrors(Collection<String> errorMessages, ImportLogger log) {
        if (errorMessages != null && !errorMessages.isEmpty()) {
            log.warn("Issue can't be linked due to the error/s [ %s ]", Joiner.on((String)"; ").join(errorMessages));
        }
    }

    private IssueLinkType getLinkTypeFromName(String name) {
        Collection issueLinkTypesByName = this.linkTypeManager.getIssueLinkTypesByName(name);
        return issueLinkTypesByName != null && !issueLinkTypesByName.isEmpty() ? (IssueLinkType)issueLinkTypesByName.iterator().next() : null;
    }

    private Either<Issue, String> getForExternalId(String externalId, List<CreatedIssueInfo> createdIssueInfos) {
        IssueService.IssueResult issueFromKey;
        CreatedIssueInfo matching = this.getIssueInfo(externalId, createdIssueInfos);
        if (matching != null && matching.getJiraIssueKey() != null && (issueFromKey = this.getIssueFromKey(matching.getJiraIssueKey())).isValid()) {
            return Either.left((Object)issueFromKey.getIssue());
        }
        return matching != null ? Either.right((Object)matching.getExternalId()) : null;
    }

    private Either<Issue, String> getForIssueKeyOrExternalId(String keyOrExternalId, List<CreatedIssueInfo> createdIssueInfos) {
        IssueService.IssueResult issueResult = this.getIssueFromKey(keyOrExternalId);
        if (issueResult.isValid()) {
            return Either.left((Object)issueResult.getIssue());
        }
        return this.getForExternalId(keyOrExternalId, createdIssueInfos);
    }

    private CreatedIssueInfo getIssueInfo(final String keyOrExternalId, List<CreatedIssueInfo> createdIssueInfos) {
        return (CreatedIssueInfo)Iterables.getFirst((Iterable)Iterables.filter(createdIssueInfos, (Predicate)new Predicate<CreatedIssueInfo>(){

            public boolean apply(CreatedIssueInfo input) {
                return keyOrExternalId.equals(input.getJiraIssueKey()) || keyOrExternalId.equals(input.getExternalId());
            }
        }), null);
    }

    private IssueService.IssueResult getIssueFromKey(String issueKey) {
        return this.bridgeUtils.getIssue(this.issueService, this.jiraAuthenticationContext.getUser(), issueKey);
    }
}

