/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.engine;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CustomFieldValueFactory;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CustomFieldsUtil;
import com.atlassian.jira.project.Project;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BulkCreateCustomFieldsHelper {
    private final CustomFieldsUtil customFieldsUtil;
    private final CustomFieldValueFactory customFieldValueFactory;
    private final IssueFactory issueFactory;

    @Autowired
    public BulkCreateCustomFieldsHelper(CustomFieldsUtil customFieldsUtil, CustomFieldValueFactory customFieldValueFactory, IssueFactory issueFactory) {
        this.customFieldsUtil = customFieldsUtil;
        this.customFieldValueFactory = customFieldValueFactory;
        this.issueFactory = issueFactory;
    }

    public Optional<String[]> prepareValueForCustomFields(ExternalCustomFieldValue customFieldValue, Project project, ImportLogger log) {
        Issue issue = this.createTempIssue(project);
        Optional<CustomField> customField = this.getCustomField(customFieldValue, project);
        if (customField.isPresent()) {
            Collection<Object> normalizedValue = this.customFieldsUtil.normalizeToCollection(customFieldValue.getValue());
            try {
                Optional<Object> result = this.customFieldValueFactory.prepareRawValueForCustomField((CustomField)customField.get(), issue, normalizedValue);
                if (result.isPresent()) {
                    return Optional.fromNullable((Object)this.resultToArray(result.get()));
                }
            }
            catch (Exception e) {
                log.warn(e, "Cannot add custom field value: " + e.getMessage(), new Object[0]);
            }
        }
        return Optional.absent();
    }

    @Nullable
    public String[] resultToArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            String[] result = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != null ? array[i].toString() : "";
            }
            return result;
        }
        if (object instanceof Collection) {
            return this.collectionToStringArray((Collection)object);
        }
        if (object instanceof Map) {
            return this.mapToStringArray((Map)object);
        }
        return new String[]{object.toString()};
    }

    private String[] mapToStringArray(Map map) {
        if (map.containsKey(null) && map.containsKey("1")) {
            return (String[])ArrayUtils.addAll((Object[])this.resultToArray(map.get(null)), (Object[])this.resultToArray(map.get("1")));
        }
        if (map.containsKey("1")) {
            return this.resultToArray(map.get("1"));
        }
        if (map.containsKey(null)) {
            return this.resultToArray(map.get(null));
        }
        return this.resultToArray(map.values());
    }

    private String[] collectionToStringArray(Collection collection) {
        String[] result = new String[collection.size()];
        Iterator iterator = collection.iterator();
        int currentIndex = 0;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            result[currentIndex++] = element != null ? element.toString() : "";
        }
        return result;
    }

    private Issue createTempIssue(Project project) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectObject(project);
        issue.setProjectId(project.getId());
        return issue;
    }

    public Optional<CustomField> getCustomField(ExternalCustomFieldValue value, Project project) {
        ExternalProject externalProject = new ExternalProject();
        externalProject.setJiraId(project.getId());
        return this.customFieldsUtil.getExistingCustomField(new ExternalCustomField(value.getFieldName(), value.getFieldName(), value.getFieldType(), value.getSearcherType()), (Set<ExternalProject>)ImmutableSet.of((Object)externalProject));
    }
}

