/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.controller;

import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.controller.BulkCreateImporterStorage;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.engine.BulkCreateImporterFactory;
import com.atlassian.jira.plugins.importer.imports.importer.ValidableJiraDataImporter;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BulkCreateImporterStorageImpl
implements BulkCreateImporterStorage {
    private final Cache<ApplicationUser, ValidableJiraDataImporter> importerCache;
    private final CompatibilityBridgeUtils bridgeUtils;

    @Autowired
    public BulkCreateImporterStorageImpl(final BulkCreateImporterFactory importerFactory, CompatibilityBridgeUtils bridgeUtils) {
        this.bridgeUtils = bridgeUtils;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS);
        this.importerCache = bridgeUtils.buildCache(cacheBuilder, new CacheLoader<ApplicationUser, ValidableJiraDataImporter>(){

            public ValidableJiraDataImporter load(ApplicationUser applicationUser) throws Exception {
                return importerFactory.createBulkCreateDataImporter();
            }
        });
    }

    @Override
    public ValidableJiraDataImporter getImporter(ApplicationUser user) {
        return this.bridgeUtils.getFromCache(this.importerCache, user);
    }
}

