/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WorklogTransformer
implements ResultSetTransformer<ExternalWorklog> {
    private final String ixBug;
    private final BugzillaConfigBean configBean;

    public WorklogTransformer(String ixBug, BugzillaConfigBean configBean) {
        this.ixBug = ixBug;
        this.configBean = configBean;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT who, added, bug_when, login_name FROM bugs_activity AS ba, profiles AS p WHERE ba.who = p.userid AND bug_id = " + this.ixBug + " AND fieldid = (SELECT " + this.configBean.getFielddefsIdColumn() + " FROM fielddefs WHERE name = 'work_time' LIMIT 1) ORDER BY bug_when ASC";
    }

    @Override
    public ExternalWorklog transform(ResultSet rs) throws SQLException {
        Float added = Float.valueOf(rs.getFloat("added"));
        ExternalWorklog worklog = new ExternalWorklog();
        worklog.setAuthor(this.configBean.getUsernameForLoginName(rs.getString("login_name")));
        worklog.setStartDate(rs.getTimestamp("bug_when"));
        worklog.setComment(this.configBean.getI18nHelper().getText("jira-importer-plugin.external.worklog.comment", (Object)worklog.getStartDate()));
        worklog.setTimeSpent((long)(3600.0 * (double)added.floatValue()));
        return worklog;
    }
}

