/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.UserTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import java.sql.SQLException;
import java.util.Collection;

public class RequiredUserTransformer
extends UserTransformer {
    private final Collection<ExternalProject> projects;
    private final boolean hasVotes;

    public RequiredUserTransformer(BugzillaConfigBean configBean, Collection<ExternalProject> projects, ImportLogger importLogger, boolean hasVotes) {
        super(configBean, importLogger);
        this.projects = projects;
        this.hasVotes = hasVotes;
    }

    @Override
    public String getSqlQuery() {
        if (this.projects.size() == 0) {
            return super.getSqlQuery();
        }
        String projectIds = SqlUtils.comma(this.projects);
        String fields = "SELECT prof.userid, prof.login_name, prof.realname, prof.disabledtext FROM profiles AS prof JOIN ";
        String union = " UNION DISTINCT ";
        return "SELECT prof.userid, prof.login_name, prof.realname, prof.disabledtext FROM profiles AS prof JOIN bugs AS b ON (b.reporter = prof.userid OR b.assigned_to = prof.userid) WHERE b.product_id IN (" + projectIds + ")" + " UNION DISTINCT " + "SELECT prof.userid, prof.login_name, prof.realname, prof.disabledtext FROM profiles AS prof JOIN " + "longdescs AS l ON (l.who = prof.userid) JOIN bugs AS b ON (l.bug_id = b.bug_id) WHERE b.product_id IN (" + projectIds + ")" + " UNION DISTINCT " + (this.hasVotes ? "SELECT prof.userid, prof.login_name, prof.realname, prof.disabledtext FROM profiles AS prof JOIN votes AS v ON (v.who = prof.userid) JOIN bugs AS b ON (v.bug_id = b.bug_id) WHERE b.product_id IN (" + projectIds + ")" + " UNION DISTINCT " : "") + "SELECT prof.userid, prof.login_name, prof.realname, prof.disabledtext FROM profiles AS prof JOIN " + "cc AS c ON (c.who = prof.userid) JOIN bugs AS b ON (c.bug_id = b.bug_id) WHERE b.product_id IN (" + projectIds + ")" + " UNION DISTINCT " + "SELECT prof.userid, prof.login_name, prof.realname, prof.disabledtext FROM profiles AS prof JOIN " + "attachments AS a ON (a.submitter_id = prof.userid) JOIN bugs AS b ON (a.bug_id = b.bug_id) WHERE b.product_id IN (" + projectIds + ")" + " UNION DISTINCT " + "SELECT prof.userid, prof.login_name, prof.realname, prof.disabledtext FROM profiles AS prof JOIN " + "bugs_activity AS ba ON (ba.who = prof.userid) JOIN bugs AS b ON (ba.bug_id = b.bug_id) WHERE ba.fieldid = (SELECT " + this.configBean.getFielddefsIdColumn() + " FROM fielddefs WHERE name = 'work_time' LIMIT 1) AND b.product_id IN (" + projectIds + ")";
    }

    public static UserTransformer create(JdbcConnection jdbcConnection, BugzillaConfigBean configBean, Collection<ExternalProject> projects, ImportLogger importLogger) {
        try {
            return new RequiredUserTransformer(configBean, projects, importLogger, SqlUtils.hasTable(jdbcConnection.getConnection(), "votes"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

