/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public class CustomFieldTransformer
implements ResultSetTransformer<ExternalCustomField> {
    @Override
    public String getSqlQuery() {
        return "SELECT * FROM fielddefs WHERE obsolete=0";
    }

    @Override
    public ExternalCustomField transform(ResultSet rs) throws SQLException {
        HashSet columns = Sets.newHashSet(SqlUtils.getColumnNames(rs.getMetaData()));
        if (!(columns.contains("custom") && columns.contains("type") && columns.contains("name") && columns.contains("description"))) {
            return null;
        }
        if (rs.getInt("custom") == 0) {
            return null;
        }
        switch (rs.getInt("type")) {
            case 2: {
                return ExternalCustomField.createSelect(rs.getString("name"), rs.getString("description"));
            }
            case 3: {
                return ExternalCustomField.createMultiSelect(rs.getString("name"), rs.getString("description"));
            }
            case 4: {
                return ExternalCustomField.createFreeText(rs.getString("name"), rs.getString("description"));
            }
            case 5: {
                return ExternalCustomField.createDatetime(rs.getString("name"), rs.getString("description"));
            }
            case 6: {
                return new ExternalCustomField(rs.getString("name"), rs.getString("description"), "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher");
            }
        }
        return ExternalCustomField.createText(rs.getString("name"), rs.getString("description"));
    }
}

