/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class ComponentTransformer
extends AbstractResultSetTransformer<ExternalComponent> {
    private final BugzillaConfigBean configBean;
    private final ExternalProject externalProject;

    public ComponentTransformer(BugzillaConfigBean configBean, ExternalProject externalProject, ImportLogger importLogger) {
        super(importLogger);
        this.configBean = configBean;
        this.externalProject = externalProject;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT name, login_name, description FROM components JOIN profiles ON (components.initialowner = profiles.userid) WHERE product_id= " + this.externalProject.getId();
    }

    @Override
    public ExternalComponent transform(ResultSet rs) throws SQLException {
        String componentName = rs.getString("name");
        if (StringUtils.isBlank((String)componentName)) {
            return null;
        }
        return new ExternalComponent(componentName, null, this.configBean.getUsernameForLoginName(rs.getString("login_name")), rs.getString("description"));
    }
}

