/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class CommentTransformer
implements ResultSetTransformer<ExternalComment> {
    private final String ixBug;
    private final BugzillaConfigBean configBean;

    public CommentTransformer(String ixBug, BugzillaConfigBean configBean) {
        this.ixBug = ixBug;
        this.configBean = configBean;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT thetext, who, bug_when, (select login_name from profiles where userid=who) AS login_name FROM longdescs WHERE bug_id = " + this.ixBug + " ORDER BY bug_when ASC";
    }

    @Override
    public ExternalComment transform(ResultSet rs) throws SQLException {
        if (rs.isFirst()) {
            return null;
        }
        ExternalComment externalComment = null;
        String commenter = this.configBean.getUsernameForLoginName(rs.getString("login_name"));
        String comment = rs.getString("thetext");
        if (StringUtils.isNotBlank((String)comment)) {
            externalComment = new ExternalComment(comment, commenter, rs.getTimestamp("bug_when"));
        }
        return externalComment;
    }
}

