/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.plugins.importer.FileCopyUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.AbstractAttachmentTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class AttachmentTransformerForDataInAttachments
extends AbstractAttachmentTransformer {
    protected final BugzillaConfigBean configBean;
    protected final ImportLogger log;
    protected final String ixBug;

    public AttachmentTransformerForDataInAttachments(String ixBug, BugzillaConfigBean configBean, ImportLogger log) {
        this.ixBug = ixBug;
        this.configBean = configBean;
        this.log = log;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT a.filename, a.creation_ts, a.thedata, a.description, p.login_name AS submitter FROM attachments AS a, profiles AS p WHERE p.userid = a.submitter_id AND bug_id = " + this.ixBug + " ORDER BY attach_id ASC";
    }

    @Override
    public ExternalAttachment transform(ResultSet rs) throws SQLException {
        ExternalAttachment externalAttachment = null;
        String fileName = rs.getString("filename");
        String attacher = this.configBean.getUsernameForLoginName(rs.getString("submitter"));
        if (StringUtils.isNotBlank((String)fileName)) {
            File file = this.copyAttachment(rs);
            externalAttachment = new ExternalAttachment(fileName, file, rs.getTimestamp("creation_ts"));
            externalAttachment.setAttacher(attacher);
            externalAttachment.setDescription(rs.getString("description"));
        }
        return externalAttachment;
    }

    protected File copyAttachment(ResultSet rs) throws SQLException {
        try {
            InputStream binaryStream = rs.getBinaryStream("thedata");
            File file = this.getTempFile();
            FileCopyUtil.copy(binaryStream, file);
            return file;
        }
        catch (IOException e) {
            throw new DataAccessException("Exception occurred dealing with attachment.", (Throwable)e);
        }
    }
}

