/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.config;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.AbstractPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.SingleStringResultTransformer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class PriorityToPriorityValueMapper
extends AbstractPriorityValueMapper {
    private final AbstractDatabaseConfigBean configBean;
    private final ExternalCustomField customField;

    public PriorityToPriorityValueMapper(AbstractDatabaseConfigBean configBean, JiraAuthenticationContext authenticationContext, FieldManager fieldManager, ExternalCustomField customField) {
        super(configBean.getJdbcConnection(), authenticationContext, fieldManager);
        this.configBean = configBean;
        this.customField = customField;
    }

    @Override
    public String getExternalFieldId() {
        return this.customField.getId();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.getI18n().getText("jira-importer-plugin.config.mapped.to.issue.field", this.customField.getName(), this.configBean.getIssueFieldMapping(this.customField.getId()));
    }

    @Override
    public Set<String> getDistinctValues() {
        return new LinkedHashSet<String>(this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT DISTINCT priority FROM bugs WHERE priority!='---' ORDER BY priority")));
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("Highest", 1), new ValueMappingEntry("High", 2), new ValueMappingEntry("Normal", 3), new ValueMappingEntry("Low", 4), new ValueMappingEntry("Lowest", 5), new ValueMappingEntry("P1", 1), new ValueMappingEntry("P2", 2), new ValueMappingEntry("P3", 3), new ValueMappingEntry("P4", 4), new ValueMappingEntry("P5", 5)}).build();
    }
}

