/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.config;

import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.plugins.importer.imports.config.AbstractValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class PlatformValueMapper
extends AbstractValueMappingDefinition {
    private static final String COMPUTER_FIELD = "rep_platform";

    public PlatformValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext) {
        super(jdbcConnection, authenticationContext);
    }

    @Override
    public String getExternalFieldId() {
        return COMPUTER_FIELD;
    }

    @Override
    public String getDescription() {
        return this.getI18n().getText("jira-importer-plugin.config.bugzilla.mappings.value.platform");
    }

    @Override
    public Set<String> getDistinctValues() {
        List<String> distinctComputers = this.jdbcConnection.queryDbAppendCollection(new ResultSetTransformer<Collection<String>>(){

            @Override
            public String getSqlQuery() {
                return "SELECT DISTINCT rep_platform FROM bugs";
            }

            @Override
            public Collection<String> transform(ResultSet rs) throws SQLException {
                String s = rs.getString(1);
                return MultiSelectCFType.extractTransferObjectFromString((String)s);
            }
        });
        return new LinkedHashSet<String>(distinctComputers);
    }
}

