/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.plugins.importer.BackCompatibilityUtil;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaClient;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.AbstractDatabaseImporterController;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterSetupPage;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.plugins.importer.web.RemoteSiteValidator;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;

public class BugzillaImporterController
extends AbstractDatabaseImporterController {
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public BugzillaImporterController(JiraDataImporter bugzillaImporter, ConfigFileHandler configFileHandler, BackCompatibilityUtil backCompatibilityUtil, @ComponentImport DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(configFileHandler, bugzillaImporter, "issue.importer.jira.bugzilla.import.bean", "Bugzilla", backCompatibilityUtil);
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    public ImportDataBean createDataBean() {
        ImportProcessBean importProcessBean = this.getImportProcessBeanFromSession();
        return new BugzillaDataBean(importProcessBean.getJdbcConnection(), (BugzillaConfigBean)importProcessBean.getConfigBean(), importProcessBean.getUrlBean(), this.dateTimeFormatterFactory);
    }

    @Override
    public AbstractDatabaseConfigBean createConfigBean(JdbcConnection jdbcConnection) {
        return new BugzillaConfigBean(jdbcConnection);
    }

    @Override
    public void validateConnection(ImporterSetupPage importerSetupPage) {
        new RemoteSiteValidator().validateConnection(importerSetupPage);
        if (!importerSetupPage.hasAnyErrors()) {
            SiteConfiguration siteConfiguration = new SiteConfiguration(importerSetupPage.getSiteUrl(), importerSetupPage.getSiteCredentials(), importerSetupPage.getSiteUsername(), importerSetupPage.getSitePassword());
            importerSetupPage.addErrorMessages(new BugzillaClient(siteConfiguration).validateConnection());
        }
    }
}

