/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.customfields.converters.DateTimePickerConverter;
import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.AttachmentTransformerFactory;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.ComponentTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.DuplicateLinksTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.IssueTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.MilestoneTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.ProjectTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.RelatedLinksTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.RequiredUserTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.UserTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.VersionTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BugzillaDataBean
extends AbstractDataBean<BugzillaConfigBean> {
    private final JdbcConnection jdbcConnection;
    private final SiteConfiguration bugzillaUrl;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final AttachmentTransformerFactory attachmentTransformerFactory;
    public static final String ISSUE_KEY_REGEX = "(?:bug|case|cases|case_id):? #?([0-9 ,]+)";

    public BugzillaDataBean(JdbcConnection jdbcConnection, BugzillaConfigBean configBean, SiteConfiguration urlBean, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(configBean);
        this.jdbcConnection = jdbcConnection;
        this.bugzillaUrl = urlBean;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.attachmentTransformerFactory = new AttachmentTransformerFactory(jdbcConnection);
    }

    @Override
    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return new HashSet<ExternalUser>(this.jdbcConnection.queryDb(RequiredUserTransformer.create(this.jdbcConnection, (BugzillaConfigBean)this.configBean, projects, importLogger)));
    }

    @Override
    public Set<ExternalUser> getAllUsers(ImportLogger log) {
        return new HashSet<ExternalUser>(this.jdbcConnection.queryDb(new UserTransformer((BugzillaConfigBean)this.configBean, log)));
    }

    @Override
    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        return Sets.newHashSet(this.jdbcConnection.queryDb(new ProjectTransformer((BugzillaConfigBean)this.configBean)));
    }

    @Override
    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        List<ExternalVersion> versions = this.jdbcConnection.queryDb(new VersionTransformer(externalProject, importLogger));
        List<ExternalVersion> affectsVersions = this.jdbcConnection.queryDb(new MilestoneTransformer(externalProject, importLogger));
        versions.addAll(affectsVersions);
        return versions;
    }

    @Override
    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(new ComponentTransformer((BugzillaConfigBean)this.configBean, externalProject, importLogger));
    }

    @Override
    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(IssueTransformer.create(this.jdbcConnection, this.bugzillaUrl.getUrl(), (BugzillaConfigBean)this.configBean, externalProject, new DateTimePickerConverter(this.dateTimeFormatterFactory), importLogger)).iterator();
    }

    @Override
    public Collection<ExternalLink> getLinks(ImportLogger log) {
        List<ExternalLink> duplicates = this.jdbcConnection.queryDb(new DuplicateLinksTransformer((BugzillaConfigBean)this.configBean));
        List<ExternalLink> related = this.jdbcConnection.queryDb(new RelatedLinksTransformer((BugzillaConfigBean)this.configBean));
        duplicates.addAll(related);
        return duplicates;
    }

    @Override
    public long getTotalIssues(final Set<ExternalProject> selectedProjects, ImportLogger log) {
        List<Long> count = this.jdbcConnection.queryDb(new ResultSetTransformer<Long>(){

            @Override
            public String getSqlQuery() {
                return "SELECT count(*) AS issues FROM bugs WHERE product_id IN (" + SqlUtils.comma(selectedProjects) + ")";
            }

            @Override
            public Long transform(ResultSet rs) throws SQLException {
                return rs.getLong("issues");
            }
        });
        return count.iterator().next();
    }

    @Override
    public String getUnusedUsersGroup() {
        return ((BugzillaConfigBean)this.configBean).getUnusedUsersGroup();
    }

    @Override
    public void cleanUp() {
        this.jdbcConnection.closeConnection();
    }

    @Override
    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        String externalIssueOldId = externalIssue.getExternalId();
        return this.jdbcConnection.queryDb(this.attachmentTransformerFactory.create((BugzillaConfigBean)this.configBean, externalIssueOldId, this.bugzillaUrl, log));
    }

    @Override
    public String getIssueKeyRegex() {
        return ISSUE_KEY_REGEX;
    }

    @Override
    public String getExternalSystemUrl() {
        return this.bugzillaUrl.getUrl();
    }
}

