/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.bugzilla.config.BugzillaValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.CustomFieldTransformer;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BugzillaConfigBean
extends AbstractDatabaseConfigBean {
    public static final String BUG_SEVERITY_FIELD = "bug_severity";
    public static final String PRIORITY_FIELD = "priority";
    public static final String DUPLICATES_LINK_NAME = "Duplicates";
    public static final String DEPENDS_LINK_NAME = "Depends on / Blocks";
    private static final String INACTIVE_USERS_GROUP = "bugzilla-import-disabled-users";
    private static final String UNUSED_USERS_GROUP = "bugzilla-import-unused-users";
    private final String fielddefsIdColumn;

    public BugzillaConfigBean(JdbcConnection jdbcConnection) {
        super(jdbcConnection);
        try {
            this.fielddefsIdColumn = SqlUtils.getColumnNames(jdbcConnection.getConnection(), "fielddefs").contains("fieldid") ? "fieldid" : "id";
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ValueMappingHelper initializeValueMappingHelper() {
        BugzillaValueMappingDefinitionsFactory mappingDefinitionFactory = new BugzillaValueMappingDefinitionsFactory(this.getJiraAuthenticationContext(), this.getConstantsManager(), this, this.getFieldManager());
        return new ValueMappingHelperImpl(mappingDefinitionFactory);
    }

    @Override
    public List<String> getExternalProjectNames() {
        return this.getJdbcConnection().queryDb(new ResultSetTransformer<String>(){

            @Override
            public String getSqlQuery() {
                return "SELECT id, name, description FROM products";
            }

            @Override
            public String transform(ResultSet rs) throws SQLException {
                return rs.getString("name");
            }
        });
    }

    @Override
    public Map<String, Map<String, String>> getAvailableFieldMappings(ExternalCustomField customField, Set<ExternalProject> projects) {
        LinkedHashMap fieldMappings = Maps.newLinkedHashMap();
        if (BUG_SEVERITY_FIELD.equals(customField.getId()) || PRIORITY_FIELD.equals(customField.getId())) {
            fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.issue.fields.header"), MapBuilder.newBuilder().add((Object)this.mapToIssueFieldValue(PRIORITY_FIELD), (Object)this.getI18nHelper().getText("issue.field.priority")).toMap());
        }
        fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.custom.fields.header"), this.getAvailableCustomFieldMappings(customField, projects));
        fieldMappings.putAll(super.getAvailableFieldMappings(customField, projects));
        return fieldMappings;
    }

    @Override
    public List<ExternalCustomField> getCustomFields() {
        ArrayList fields = Lists.newArrayList((Object[])new ExternalCustomField[]{new ExternalCustomField("bug_url", "External issue URL", "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher"), ExternalCustomField.createSelect(BUG_SEVERITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.customfield.severity.name")), ExternalCustomField.createSelect(PRIORITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.customfield.priority.name")), ExternalCustomField.createText("status_whiteboard", this.getI18nHelper().getText("jira-importer-plugin.external.bugzilla.status_whiteboard"))});
        fields.addAll(this.jdbcConnection.queryDb(new CustomFieldTransformer()));
        return fields;
    }

    @Override
    public List<String> getLinkNamesFromDb() {
        return new ImmutableList.Builder().add((Object[])new String[]{DUPLICATES_LINK_NAME, DEPENDS_LINK_NAME}).build();
    }

    public String getUsernameForLoginName(@Nullable String loginName) {
        String username = this.getValueMappingHelper().getValueMappingForImport("login_name", StringUtils.defaultIfEmpty((String)loginName, (String)"deleted"));
        return username.toLowerCase(Locale.ENGLISH);
    }

    public String getInactiveUsersGroup() {
        return INACTIVE_USERS_GROUP;
    }

    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }

    @Override
    public void populateFieldMappings(Map actionParams, ErrorCollection errors) {
        super.populateFieldMappings(actionParams, errors);
        if (this.fieldMapping.get(BUG_SEVERITY_FIELD) != null && ((String)this.fieldMapping.get(BUG_SEVERITY_FIELD)).equals(this.fieldMapping.get(PRIORITY_FIELD))) {
            errors.addError(BUG_SEVERITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.config.mappings.duplicate.custom.fields", BUG_SEVERITY_FIELD, PRIORITY_FIELD));
            errors.addError(PRIORITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.config.mappings.duplicate.custom.fields", BUG_SEVERITY_FIELD, PRIORITY_FIELD));
        }
    }

    public String getFielddefsIdColumn() {
        return this.fielddefsIdColumn;
    }
}

