/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugins.importer.imports.HttpDownloader;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class BugzillaClient
extends HttpDownloader {
    private static final int MAX_LINE_READ = 50;
    private static final Pattern tokenPattern = Pattern.compile("<input\\s*type=\"hidden\"\\s*name=\"Bugzilla_login_token\"\\s*value=\"(.*?)\"\\s*>", 8);
    private static final Logger log = Logger.getLogger(BugzillaClient.class);
    private final SiteConfiguration urlBean;
    private HttpContext httpContext;
    private boolean logged;
    private static final Pattern pattern = Pattern.compile("<title>.*</title>");

    public BugzillaClient(SiteConfiguration urlBean) {
        this.urlBean = urlBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> validateBugzillaUrl() {
        DefaultHttpClient client = this.createHttpClient();
        try {
            HttpGet get = new HttpGet(this.urlBean.getUrl());
            HttpResponse status = client.execute((HttpUriRequest)get);
            try {
                if (status.getStatusLine().getStatusCode() == 200) {
                    String encoding = StringUtils.defaultIfEmpty((String)EntityUtils.getContentCharSet((HttpEntity)status.getEntity()), (String)"ISO-8859-1");
                    if (BugzillaClient.hasBugzillaTitle(status.getEntity().getContent(), encoding, 50)) {
                        Map<String, String> map = Collections.emptyMap();
                        return map;
                    }
                    Map map = MapBuilder.build((Object)this.getI18nBean().getText("jira-importer-plugin.external.bugzilla.site.url.notdetected"), null);
                    return map;
                }
                Map map = MapBuilder.build((Object)this.getI18nBean().getText("jira-importer-plugin.external.bugzilla.site.url.notdetected"), (Object)this.getI18nBean().getText("jira-importer-plugin.importer.site.url.httperrorcode", Integer.toString(status.getStatusLine().getStatusCode()), get.getURI().toString()));
                return map;
            }
            finally {
                EntityUtils.consume((HttpEntity)status.getEntity());
            }
        }
        catch (Exception e) {
            String string;
            I18nHelper i18nHelper = this.getI18nBean();
            String string2 = this.urlBean.getUrl();
            if (e.getMessage() == null) {
                string = e.getCause().getMessage();
                return MapBuilder.build((Object)i18nHelper.getText("jira-importer-plugin.importer.site.connection.failed", string2, string), null);
            }
            string = e.getMessage();
            return MapBuilder.build((Object)i18nHelper.getText("jira-importer-plugin.importer.site.connection.failed", string2, string), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsLoginForm(File input, String encoding) throws IOException {
        FileInputStream is = new FileInputStream(input);
        try {
            boolean bl = this.containsLoginForm(is, encoding);
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private boolean containsLoginForm(InputStream is, String encoding) throws IOException {
        LineIterator iter = IOUtils.lineIterator((InputStream)is, (String)(StringUtils.isNotBlank((String)encoding) ? encoding : this.client.getParams().getParameter("http.protocol.content-charset").toString()));
        boolean login = false;
        boolean password = false;
        boolean go = false;
        while (iter.hasNext()) {
            String line = iter.nextLine();
            login |= line.contains("name=\"Bugzilla_login\"");
            password |= line.contains("name=\"Bugzilla_password\"");
            go |= line.contains("name=\"GoAheadAndLogIn\"");
        }
        return login && password && go;
    }

    @Override
    protected void validateAttachment(String ixBug, HttpResponse get, File file) throws IOException {
        if (get.getEntity().getContentType().getValue().startsWith("text/html") && this.containsLoginForm(file, StringUtils.defaultIfEmpty((String)EntityUtils.getContentCharSet((HttpEntity)get.getEntity()), (String)"ISO-8859-1"))) {
            throw new IOException(String.format("Authentication required to access attachment %s.", ixBug));
        }
    }

    public File getAttachment(String ixBug, String attachId) throws IOException {
        String attachUrl = this.urlBean.getUrl() + "/attachment.cgi?id=" + attachId;
        return this.getAttachmentFromUrl(this.httpContext, ixBug, attachUrl);
    }

    public void login() throws IOException {
        if (!this.logged) {
            this.httpContext = this.createHttpContext();
            String error = this.doLogin((HttpClient)this.client, this.httpContext);
            if (error != null) {
                throw new IOException(error);
            }
            this.logged = true;
        }
    }

    public void logout() throws IOException {
        this.logged = false;
        this.httpContext = null;
        this.client.getConnectionManager().shutdown();
    }

    private String doLogin(HttpClient client, HttpContext httpContext) {
        String errorMessage = this.doLoginToBugzilla(client, httpContext, (Optional<String>)Optional.absent());
        if (errorMessage == null) {
            return null;
        }
        Optional<String> token = this.retrieveBugzillaToken(client, httpContext);
        if (token.isPresent()) {
            return this.doLoginToBugzilla(client, httpContext, token);
        }
        return errorMessage;
    }

    private Optional<String> retrieveBugzillaToken(HttpClient client, HttpContext httpContext) {
        HttpGet httpGet = new HttpGet(this.urlBean.getUrl() + "/index.cgi?GoAheadAndLogIn=1");
        try {
            HttpResponse response = client.execute((HttpUriRequest)httpGet, httpContext);
            HttpEntity entity = response.getEntity();
            String responseString = IOUtils.toString((InputStream)entity.getContent(), (String)this.getEncoding(entity));
            Matcher matcher = tokenPattern.matcher(responseString);
            if (matcher.find()) {
                return Optional.of((Object)matcher.group(1));
            }
            IOUtils.closeQuietly((InputStream)entity.getContent());
        }
        catch (IOException e) {
            httpGet.abort();
            log.warn((Object)"Cannot download token from Bugzilla", (Throwable)e);
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String doLoginToBugzilla(HttpClient client, HttpContext httpContext, Optional<String> token) {
        HttpPost post = new HttpPost(this.urlBean.getUrl() + "/index.cgi");
        try {
            ArrayList parameters = Lists.newArrayList((Object[])new NameValuePair[]{new BasicNameValuePair("Bugzilla_login", this.urlBean.getUsername()), new BasicNameValuePair("Bugzilla_password", this.urlBean.getPassword()), new BasicNameValuePair("Bugzilla_restrictlogin", "checked"), new BasicNameValuePair("GoAheadAndLogIn", "Log In")});
            if (token.isPresent()) {
                parameters.add(new BasicNameValuePair("Bugzilla_login_token", (String)token.get()));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity((List)parameters));
            HttpResponse status = client.execute((HttpUriRequest)post, httpContext);
            try {
                if (status.getStatusLine().getStatusCode() == 200) {
                    Collection<String> missingCookies;
                    InputStream is = status.getEntity().getContent();
                    if (is != null) {
                        try {
                            String bugzillaResponse = IOUtils.toString((InputStream)is, (String)this.getEncoding(status.getEntity()));
                            if (this.containsError(bugzillaResponse)) {
                                String string = this.getI18nBean().getText("jira-importer-plugin.importer.site.credentials.invalid");
                                return string;
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)is);
                        }
                    }
                    if (!(missingCookies = this.getMissingCookies(httpContext, (Collection<String>)ImmutableSet.of((Object)"Bugzilla_logincookie"))).isEmpty()) {
                        String string = this.getI18nBean().getText("jira-importer-plugin.importer.missing.cookies", StringUtils.join(missingCookies, (String)","));
                        return string;
                    }
                    String string = null;
                    return string;
                }
                String string = this.getI18nBean().getText("jira-importer-plugin.importer.site.url.httperrorcode") + " " + status;
                return string;
            }
            finally {
                EntityUtils.consume((HttpEntity)status.getEntity());
            }
        }
        catch (Exception e) {
            post.abort();
            log.warn((Object)"Cannot login to Bugzilla", (Throwable)e);
            return this.getI18nBean().getText("jira-importer-plugin.importer.site.connection.failed", this.urlBean.getUrl(), e.getMessage());
        }
    }

    private String getEncoding(HttpEntity entity) {
        try {
            ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
            if (contentType.getCharset() != null) {
                return contentType.getCharset().displayName();
            }
        }
        catch (ParseException e) {
            log.warn((Object)"Cannot parse bugzilla response Content Type", (Throwable)e);
        }
        return "UTF-8";
    }

    public String validateCredentials() {
        DefaultHttpClient client = this.createHttpClient();
        return this.doLogin((HttpClient)client, this.createHttpContext());
    }

    private boolean containsError(String bugzillaResponse) throws IOException {
        LineIterator iter = IOUtils.lineIterator((Reader)new StringReader(bugzillaResponse));
        while (iter.hasNext()) {
            String line = iter.nextLine();
            if (!line.contains("id=\"error_msg\"") && !line.contains("class=\"throw_error\"")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasBugzillaTitle(InputStream in, String encoding, int maxLineRead) throws IOException {
        BufferedReader isr = new BufferedReader(new InputStreamReader(in, encoding));
        try {
            int counter = 0;
            String line = isr.readLine();
            while (line != null) {
                if (pattern.matcher(line).find()) {
                    boolean bl = true;
                    return bl;
                }
                if (counter == maxLineRead) {
                    boolean bl = false;
                    return bl;
                }
                line = isr.readLine();
                ++counter;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Reader)isr);
        }
    }

    protected I18nHelper getI18nBean() {
        return ((JiraAuthenticationContext)ComponentManager.getComponent(JiraAuthenticationContext.class)).getI18nHelper();
    }

    public Map<String, String> validateConnection() {
        String error;
        HashMap errors = Maps.newHashMap();
        errors.putAll(this.validateBugzillaUrl());
        if (errors.isEmpty() && this.urlBean.isUseCredentials() && (error = this.validateCredentials()) != null) {
            errors.put(error, null);
        }
        return errors;
    }

    public SiteConfiguration getUrlBean() {
        return this.urlBean;
    }

    public boolean isAuthenticated() {
        return this.logged;
    }
}

