/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports;

import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpDownloader {
    protected final DefaultHttpClient client = this.createHttpClient();
    private static final String PREFIX = "jira-importers-plugin-downloader-";
    private static final String TMP = ".tmp";

    public HttpContext createHttpContext() {
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
        return context;
    }

    protected DefaultHttpClient createHttpClient() {
        DefaultHttpClient res = new DefaultHttpClient();
        res.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        HttpDownloader.setDefaultProxy(res);
        return res;
    }

    public static void setDefaultProxy(DefaultHttpClient client) {
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        client.setRoutePlanner((HttpRoutePlanner)routePlanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getAttachmentFromUrl(@Nullable HttpContext context, String ixBug, String attachUrl) throws IOException {
        if ("file".equals(new URI(attachUrl, false).getScheme())) {
            throw new IOException("For security reasons you are not allowed to use file protocol.");
        }
        HttpGet get = new HttpGet(attachUrl);
        HttpResponse response = this.client.execute((HttpUriRequest)get, context);
        try {
            if (response.getStatusLine().getStatusCode() == 200) {
                File file = File.createTempFile(PREFIX, TMP);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                }
                this.validateAttachment(ixBug, response, file);
                File file2 = file;
                return file2;
            }
            throw new IOException(String.format("Error downloading attachment for %s from %s. Error: HTTP status code: %d", ixBug, attachUrl, response.getStatusLine().getStatusCode()));
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    protected void validateAttachment(String ixBug, HttpResponse get, File file) throws IOException {
    }

    protected Collection<String> getMissingCookies(HttpContext context, Collection<String> requiredCookies) {
        CookieStore store = (CookieStore)context.getAttribute("http.cookie-store");
        if (store == null) {
            return requiredCookies;
        }
        List cookies = store.getCookies();
        if (cookies == null) {
            return requiredCookies;
        }
        HashSet receivedCookies = Sets.newHashSetWithExpectedSize((int)cookies.size());
        for (Cookie cookie : cookies) {
            receivedCookies.add(cookie.getName());
        }
        HashSet result = Sets.newHashSet(requiredCookies);
        result.removeAll(receivedCookies);
        return result;
    }
}

