/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.plugins.importer.imports.config.AbstractValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractResolutionValueMapper
extends AbstractValueMappingDefinition {
    private final ConstantsManager constantsManager;

    public AbstractResolutionValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager) {
        super(jdbcConnection, authenticationContext);
        this.constantsManager = constantsManager;
    }

    @Override
    public final String getJiraFieldId() {
        return "resolution";
    }

    public String transformResolution(String resolution) {
        return resolution;
    }

    @Override
    public final Set<String> getDistinctValues() {
        List<String> distinctResolutions = this.jdbcConnection.queryDbAppendCollection(new ResultSetTransformer<Collection<String>>(){

            @Override
            public String getSqlQuery() {
                return AbstractResolutionValueMapper.this.getSqlQuery();
            }

            @Override
            public Collection<String> transform(ResultSet rs) throws SQLException {
                String s = AbstractResolutionValueMapper.this.transformResolution(rs.getString(1));
                return MultiSelectCFType.extractTransferObjectFromString((String)s);
            }
        });
        return new LinkedHashSet<String>(distinctResolutions);
    }

    protected abstract String getSqlQuery();

    @Override
    public final Collection<ValueMappingEntry> getTargetValues() {
        return AbstractResolutionValueMapper.getAllResolutions(this.constantsManager);
    }

    public static Collection<ValueMappingEntry> getAllResolutions(ConstantsManager constantsManager) {
        return new ArrayList<ValueMappingEntry>(Collections2.transform((Collection)constantsManager.getResolutionObjects(), (Function)new AbstractValueMappingDefinition.IssueConstantToValueMapping()));
    }

    @Override
    public final boolean canBeBlank() {
        return false;
    }
}

