/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports;

import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractProjectTransformer<T extends AbstractDatabaseConfigBean>
implements ResultSetTransformer<ExternalProject> {
    private final T configBean;

    public AbstractProjectTransformer(T configBean) {
        this.configBean = configBean;
    }

    protected abstract ExternalProject create(ResultSet var1) throws SQLException;

    @Override
    @Nullable
    public ExternalProject transform(ResultSet rs) throws SQLException {
        return this.map(this.create(rs));
    }

    public T getConfigBean() {
        return this.configBean;
    }

    @Nullable
    protected ExternalProject map(ExternalProject externalProject) {
        return AbstractProjectTransformer.map(this.configBean, externalProject);
    }

    @Nonnull
    public static ExternalProject map(@Nonnull AbstractConfigBean2 configBean, @Nonnull ExternalProject externalProject) {
        ExternalProject project = new ExternalProject();
        project.setExternalName(externalProject.getName());
        project.setKey(configBean.getProjectKey(externalProject.getName()));
        project.setName(configBean.getProjectName(externalProject.getName()));
        project.setId(externalProject.getId());
        project.setDescription(externalProject.getDescription());
        project.setLead(configBean.getProjectLead(externalProject.getName()));
        return project;
    }
}

