/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports;

import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractIssueTransformer<C extends AbstractDatabaseConfigBean>
extends AbstractResultSetTransformer<ExternalIssue> {
    protected final JdbcConnection jdbcConnection;
    protected final C configBean;

    public AbstractIssueTransformer(C configBean, ImportLogger log) {
        super(log);
        this.configBean = configBean;
        this.jdbcConnection = ((AbstractDatabaseConfigBean)configBean).getJdbcConnection();
    }

    protected void setCustomFieldValues(ExternalIssue externalIssue, ResultSet rs, String bugId) throws SQLException {
        ArrayList customFields = Lists.newArrayList();
        for (ExternalCustomField customField : ((AbstractConfigBean2)this.configBean).getCustomFields()) {
            Object value = this.getCustomFieldValue(rs, bugId, customField);
            if (((AbstractConfigBean2)this.configBean).isFieldMappedToIssueField(customField.getId())) {
                externalIssue.setField(((AbstractConfigBean2)this.configBean).getIssueFieldMapping(customField.getId()), value);
                continue;
            }
            String mapping = ((AbstractConfigBean2)this.configBean).getFieldMapping(customField.getId());
            String customFieldName = StringUtils.isNotEmpty((String)mapping) ? mapping : customField.getName();
            customFields.add(new ExternalCustomField(customField.getId(), customFieldName, customField.getTypeKey(), customField.getSearcherKey()).createValue(value));
        }
        externalIssue.setExternalCustomFieldValues(customFields);
    }

    @Nullable
    protected abstract Object getCustomFieldValue(ResultSet var1, String var2, ExternalCustomField var3) throws SQLException;
}

