/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.external.beans;

import com.atlassian.jira.plugins.importer.external.beans.NamedExternalObject;
import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class ExternalUser
implements NamedExternalObject {
    private String id;
    private String name;
    private String fullname;
    private String email;
    private final Set<String> groups = new HashSet<String>();
    private final Multimap<String, String> projectRoles = HashMultimap.create();
    private boolean active = true;

    public ExternalUser() {
    }

    public ExternalUser(ExternalUser user) {
        this.id = user.id;
        this.name = user.name;
        this.fullname = user.fullname;
        this.email = user.email;
        this.groups.addAll(user.groups);
        this.active = user.active;
        this.projectRoles.putAll(user.projectRoles);
    }

    public ExternalUser(String name, String fullname) {
        this.name = name;
        this.fullname = fullname;
    }

    public ExternalUser(String name, String fullname, String email) {
        this.name = name;
        this.fullname = fullname;
        this.email = email;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups.clear();
        this.groups.addAll(groups);
    }

    @JsonIgnore
    public void addRole(String project, String role) {
        this.projectRoles.put((Object)project, (Object)role);
    }

    @JsonIgnore
    public Multimap<String, String> getProjectRoles() {
        return Multimaps.unmodifiableMultimap(this.projectRoles);
    }

    @JsonProperty
    public void setProjectRoles(Map<String, List<String>> projectRoles) {
        this.projectRoles.clear();
        for (Map.Entry<String, List<String>> entry : projectRoles.entrySet()) {
            this.projectRoles.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    @JsonIgnore
    public void setProjectRoles(Multimap<String, String> projectRoles) {
        this.projectRoles.clear();
        this.projectRoles.putAll(projectRoles);
    }

    @JsonIgnore
    @Nullable
    public String getPassword() {
        return null;
    }

    public static final class FullNameFunction
    implements Function<ExternalUser, String> {
        public String apply(@Nonnull ExternalUser from) {
            return from.getFullname();
        }
    }
}

