/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.external.beans;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryGroup;
import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonSetter;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class ExternalIssue {
    private static final Logger log = Logger.getLogger(ExternalIssue.class);
    private String externalId;
    private boolean autoExternalId;
    @Nullable
    private String key;
    private String summary;
    private String reporter;
    private String assignee;
    private String description;
    private String environment;
    private String issueType;
    private String status;
    private String priority;
    private String resolution;
    private DateTime created;
    private DateTime updated;
    private DateTime resolutionDate;
    private DateTime duedate;
    private Long votes;
    private Period originalEstimate;
    private Period timeSpent;
    private Period estimate;
    private List<String> affectedVersions;
    private List<String> fixedVersions;
    private List<String> components;
    private final List<ExternalComment> externalComments = Lists.newArrayList();
    private final List<ExternalCustomFieldValue> externalCustomFieldValues = Lists.newArrayList();
    private final Set<String> labels = Sets.newHashSet();
    private final List<ExternalWorklog> worklogs = Lists.newArrayList();
    private final List<String> voters = Lists.newArrayList();
    private final List<String> watchers = Lists.newArrayList();
    private final List<ExternalIssue> subtasks = Lists.newArrayList();
    private final List<ExternalAttachment> attachments = Lists.newArrayList();
    private final Map<String, String> properties = Maps.newHashMap();
    private List<ExternalHistoryGroup> history = Collections.emptyList();

    public ExternalIssue() {
    }

    public ExternalIssue(ExternalIssue issue) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)issue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.setAffectedVersions(issue.affectedVersions);
        this.setFixedVersions(issue.fixedVersions);
        this.setComponents(issue.components);
        this.setComments(issue.externalComments);
        this.setExternalCustomFieldValues(issue.externalCustomFieldValues);
        this.setLabels(issue.labels);
        this.setWorklogs(issue.worklogs);
        this.setVoters(issue.voters);
        this.setWatchers(issue.watchers);
        this.setAttachments(issue.attachments);
        this.setSubtasks(Collections2.transform(issue.subtasks, (Function)new Function<ExternalIssue, ExternalIssue>(){

            public ExternalIssue apply(ExternalIssue input) {
                return new ExternalIssue(input);
            }
        }));
    }

    public void setWorklogs(List<ExternalWorklog> worklog) {
        this.worklogs.clear();
        this.worklogs.addAll(worklog);
    }

    public List<ExternalWorklog> getWorklogs() {
        return ImmutableList.copyOf(this.worklogs);
    }

    public void setLabels(Collection<String> labels) {
        this.labels.clear();
        this.labels.addAll(labels);
    }

    public Set<String> getLabels() {
        return ImmutableSet.copyOf(this.labels);
    }

    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(@Nullable String externalId) {
        this.externalId = externalId;
    }

    @JsonProperty(value="affectedVersions")
    @Nullable
    public Collection<String> getAffectedVersions() {
        return this.affectedVersions;
    }

    @JsonIgnore
    public void setAffectedVersions(@Nullable Iterable<String> affectedVersions) {
        this.affectedVersions = affectedVersions != null ? ImmutableList.copyOf(affectedVersions) : null;
    }

    @JsonSetter(value="affectedVersions")
    private void setAffectedVersionsForJson(@Nullable Collection<String> affectedVersions) {
        this.setAffectedVersions(affectedVersions);
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return Maps.newHashMap(this.properties);
    }

    @JsonIgnore
    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @JsonSetter(value="properties")
    public void setProperties(Map<String, String> properties) {
        properties.putAll(properties);
    }

    @JsonProperty(value="fixedVersions")
    @Nullable
    public Collection<String> getFixedVersions() {
        return this.fixedVersions;
    }

    @JsonIgnore
    public void setFixedVersions(@Nullable Iterable<String> fixedVersions) {
        this.fixedVersions = fixedVersions != null ? ImmutableList.copyOf(fixedVersions) : null;
    }

    @JsonSetter(value="fixedVersions")
    private void setFixedVersionsForJson(@Nullable Collection<String> fixedVersions) {
        this.setFixedVersions(fixedVersions);
    }

    @JsonProperty(value="components")
    public List<String> getComponents() {
        return this.components;
    }

    @JsonIgnore
    public void setComponents(@Nullable Iterable<String> externalComponents) {
        this.components = externalComponents != null ? ImmutableList.copyOf(externalComponents) : null;
    }

    @JsonSetter(value="components")
    private void setComponentsForJson(@Nullable Collection<String> externalComponents) {
        this.setComponents(externalComponents);
    }

    public List<ExternalComment> getComments() {
        return ImmutableList.copyOf(this.externalComments);
    }

    public void setComments(Collection<ExternalComment> externalComments) {
        this.externalComments.clear();
        this.externalComments.addAll(externalComments);
    }

    public void addExternalCustomFieldValue(ExternalCustomFieldValue externalCustomFieldValue) {
        this.externalCustomFieldValues.add(externalCustomFieldValue);
    }

    @JsonProperty(value="customFieldValues")
    public List<ExternalCustomFieldValue> getExternalCustomFieldValues() {
        return ImmutableList.copyOf(this.externalCustomFieldValues);
    }

    @JsonProperty(value="customFieldValues")
    public void setExternalCustomFieldValues(List<ExternalCustomFieldValue> externalCustomFieldValues) {
        this.externalCustomFieldValues.clear();
        this.externalCustomFieldValues.addAll(externalCustomFieldValues);
    }

    @Nullable
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(@Nullable String summary) {
        this.summary = StringUtils.trimToNull((String)summary);
    }

    @Nullable
    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(@Nullable String reporter) {
        this.reporter = StringUtils.trimToNull((String)reporter);
    }

    @Nullable
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(@Nullable String assignee) {
        this.assignee = StringUtils.trimToNull((String)assignee);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = StringUtils.trimToNull((String)description);
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@Nullable String environment) {
        this.environment = StringUtils.trimToNull((String)environment);
    }

    @Nullable
    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(@Nullable String issueType) {
        this.issueType = StringUtils.trimToNull((String)issueType);
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable String status) {
        this.status = StringUtils.trimToNull((String)status);
    }

    @Nullable
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(@Nullable String priority) {
        this.priority = StringUtils.trimToNull((String)priority);
    }

    @Nullable
    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(@Nullable String resolution) {
        this.resolution = StringUtils.trimToNull((String)resolution);
    }

    @Nullable
    public DateTime getCreated() {
        return this.created;
    }

    @JsonIgnore
    public void setCreated(@Nullable Date created) {
        this.setCreated(created != null ? new DateTime((Object)created) : null);
    }

    @JsonProperty
    public void setCreated(@Nullable DateTime created) {
        this.created = created;
    }

    @Nullable
    public DateTime getUpdated() {
        return this.updated;
    }

    @JsonIgnore
    public void setUpdated(@Nullable Date updated) {
        this.setUpdated(updated != null ? new DateTime((Object)updated) : null);
    }

    @JsonProperty
    public void setUpdated(@Nullable DateTime updated) {
        this.updated = updated != null ? new DateTime((Object)updated) : null;
    }

    @Nullable
    public DateTime getResolutionDate() {
        return this.resolutionDate;
    }

    @JsonIgnore
    public void setResolutionDate(@Nullable Date resolutionDate) {
        this.setResolutionDate(resolutionDate != null ? new DateTime((Object)resolutionDate) : null);
    }

    @JsonProperty
    public void setResolutionDate(@Nullable DateTime resolutionDate) {
        this.resolutionDate = resolutionDate;
    }

    @Nullable
    public DateTime getDuedate() {
        return this.duedate;
    }

    @JsonIgnore
    public void setDuedate(@Nullable Date duedate) {
        this.setDuedate(duedate != null ? new DateTime((Object)duedate) : null);
    }

    @JsonProperty
    public void setDuedate(@Nullable DateTime duedate) {
        this.duedate = duedate;
    }

    @Nullable
    public Long getVotes() {
        return this.votes;
    }

    public void setVotes(@Nullable Long votes) {
        this.votes = votes;
    }

    @Nullable
    public Period getOriginalEstimate() {
        return this.originalEstimate;
    }

    @JsonProperty
    public void setOriginalEstimate(@Nullable Period originalEstimate) {
        this.originalEstimate = originalEstimate;
    }

    @JsonIgnore
    public void setOriginalEstimate(@Nullable Long originalEstimate) {
        this.originalEstimate = originalEstimate != null ? Period.seconds((int)originalEstimate.intValue()) : null;
    }

    @Nullable
    public Period getTimeSpent() {
        return this.timeSpent;
    }

    @JsonProperty
    public void setTimeSpent(@Nullable Period timeSpent) {
        this.timeSpent = timeSpent;
    }

    @JsonIgnore
    public void setTimeSpent(@Nullable Long timeSpent) {
        this.timeSpent = timeSpent != null ? Period.seconds((int)timeSpent.intValue()) : null;
    }

    @Nullable
    public Period getEstimate() {
        return this.estimate;
    }

    @JsonProperty
    public void setEstimate(@Nullable Period estimate) {
        this.estimate = estimate;
    }

    @JsonIgnore
    public void setEstimate(@Nullable Long estimate) {
        this.estimate = estimate != null ? Period.seconds((int)estimate.intValue()) : null;
    }

    public void setField(String fieldName, @Nullable Object value) {
        try {
            fieldName = this.processFieldName(fieldName);
            BeanUtils.setProperty((Object)this, (String)fieldName, (Object)value);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to set field using reflection for :" + fieldName + ":" + value));
        }
    }

    @Nullable
    public String getField(String fieldName) {
        try {
            fieldName = this.processFieldName(fieldName);
            return BeanUtils.getProperty((Object)this, (String)fieldName);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to get field using reflection for :" + fieldName));
            return null;
        }
    }

    private String processFieldName(String fieldName) {
        if (ConstantsManager.ISSUE_TYPE_CONSTANT_TYPE.equalsIgnoreCase(fieldName)) {
            fieldName = "issueType";
        }
        return fieldName;
    }

    public String toString() {
        return "[externalId='" + this.externalId + '\'' + ", summary='" + this.summary + '\'' + ']';
    }

    public void setVoters(Collection<String> strings) {
        this.voters.clear();
        this.voters.addAll(strings);
    }

    public List<String> getVoters() {
        return ImmutableList.copyOf(this.voters);
    }

    public void setWatchers(List<String> strings) {
        this.watchers.clear();
        this.watchers.addAll(strings);
    }

    public List<String> getWatchers() {
        return ImmutableList.copyOf(this.watchers);
    }

    public List<ExternalIssue> getSubtasks() {
        return ImmutableList.copyOf(this.subtasks);
    }

    public void setSubtasks(Collection<ExternalIssue> subtasks) {
        this.subtasks.clear();
        this.subtasks.addAll(subtasks);
    }

    public List<ExternalAttachment> getAttachments() {
        return ImmutableList.copyOf(this.attachments);
    }

    public void setAttachments(List<ExternalAttachment> attachments) {
        this.attachments.clear();
        this.attachments.addAll(attachments);
    }

    @Nullable
    public List<ExternalHistoryGroup> getHistory() {
        return this.history;
    }

    public void setHistory(List<ExternalHistoryGroup> history) {
        this.history = history != null ? ImmutableList.copyOf(history) : Collections.emptyList();
    }

    @JsonIgnore
    public boolean isAutoExternalId() {
        return this.autoExternalId;
    }

    @JsonIgnore
    public void setAutoExternalId(boolean autoExternalId) {
        this.autoExternalId = autoExternalId;
    }

    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }
}

