/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.external.beans;

import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.imports.config.AbstractValueMappingDefinition;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ExternalCustomField {
    private final String id;
    private final String name;
    private final String typeKey;
    private final String searcherKey;
    private AbstractValueMappingDefinition valueMappingDefinition;
    private Collection<String> valueSet;

    public ExternalCustomField(String id, String name, String typeKey, @Nullable String searcherKey) {
        if (id == null || name == null || typeKey == null) {
            throw new IllegalArgumentException("Can not construct an ExternalCustomField with null arguments.");
        }
        this.id = id;
        this.name = name;
        this.typeKey = typeKey;
        this.searcherKey = searcherKey;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    @Nullable
    public String getSearcherKey() {
        return this.searcherKey;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public static ExternalCustomField createText(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher");
    }

    public static ExternalCustomField createSelect(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:select", "com.atlassian.jira.plugin.system.customfieldtypes:selectsearcher");
    }

    public static ExternalCustomField createMultiSelect(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:multiselect", "com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher");
    }

    public static ExternalCustomField createFreeText(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:textarea", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher");
    }

    public static ExternalCustomField createDatePicker(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:datepicker", "com.atlassian.jira.plugin.system.customfieldtypes:daterange");
    }

    public static ExternalCustomField createDatetime(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:datetime", "com.atlassian.jira.plugin.system.customfieldtypes:datetimerange");
    }

    public static ExternalCustomField createNumber(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:float", "com.atlassian.jira.plugin.system.customfieldtypes:exactnumber");
    }

    public static ExternalCustomField createRadio(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", "com.atlassian.jira.plugin.system.customfieldtypes:radiosearcher");
    }

    public static ExternalCustomField createCheckboxes(String id, String name) {
        return new ExternalCustomField(id, name, "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", "com.atlassian.jira.plugin.system.customfieldtypes:checkboxsearcher");
    }

    @Nullable
    public AbstractValueMappingDefinition getValueMappingDefinition() {
        return this.valueMappingDefinition;
    }

    public void setValueMappingDefinition(@Nullable AbstractValueMappingDefinition valueMappingDefinition) {
        this.valueMappingDefinition = valueMappingDefinition;
    }

    @Nullable
    public Collection<String> getValueSet() {
        return this.valueSet;
    }

    public void setValueSet(@Nullable Collection<String> valueSet) {
        this.valueSet = valueSet;
    }

    public ExternalCustomFieldValue createValue(@Nullable Object value) {
        if (value != null) {
            if ("com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes".equals(this.getTypeKey()) || "com.atlassian.jira.plugin.system.customfieldtypes:multiselect".equals(this.getTypeKey()) || "com.atlassian.jira.plugin.system.customfieldtypes:multiversion".equals(this.getTypeKey())) {
                if (!(value instanceof Collection)) {
                    throw new IllegalArgumentException(String.format("Unable to create a value for custom field %s: invalid type: %s; must be a Collection", this.getName(), value.getClass().toString()));
                }
            } else if (!(value instanceof String)) {
                throw new IllegalArgumentException(String.format("Unable to create a value for custom field %s: invalid type: %s; must be a String", this.getName(), value.getClass().toString()));
            }
        }
        return new ExternalCustomFieldValue(this.getName(), this.getTypeKey(), this.getSearcherKey(), value);
    }
}

