/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.extensions;

import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ExternalSystemImporterModuleDescriptor
extends AbstractJiraModuleDescriptor<ImporterController>
implements StateAware {
    private String logoModuleKey;
    private String logoFile;
    private String supportedVersions;
    private String description;
    private Class<? extends ImporterController> controllerFactory;
    private Condition condition;
    private int weight = 999;
    private boolean isNonAdmin = false;
    private String onboardingPanelKey;
    private final ConditionElementParser conditionElementParser;
    private final HelpUrls helpUrls;
    protected Element element;

    public ExternalSystemImporterModuleDescriptor(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ModuleFactory moduleFactory, final @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport HelpUrls helpUrls) {
        super(authenticationContext, moduleFactory);
        this.helpUrls = helpUrls;
        this.conditionElementParser = new ConditionElementParser(new ConditionElementParser.ConditionFactory(){

            public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
                return webInterfaceManager.getWebFragmentHelper().loadCondition(className, plugin);
            }
        });
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
        this.description = element.attributeValue("i18n-description-key");
        this.logoModuleKey = element.attributeValue("logo-module-key");
        if (StringUtils.isBlank((String)this.logoModuleKey)) {
            throw new PluginParseException("logo-module-key must not be empty");
        }
        this.logoFile = element.attributeValue("logo-file");
        if (StringUtils.isBlank((String)this.logoFile)) {
            throw new PluginParseException("logo-file must not be empty");
        }
        this.supportedVersions = element.attributeValue("i18n-supported-versions-key");
        this.onboardingPanelKey = element.attributeValue("onboarding-panel-key");
        String nonAdminValue = element.attributeValue("non-admin");
        boolean bl = this.isNonAdmin = nonAdminValue != null && "true".equalsIgnoreCase(nonAdminValue);
        if (StringUtils.isNotBlank((String)element.attributeValue("weight"))) {
            this.weight = Integer.valueOf(element.attributeValue("weight"));
        }
    }

    public void enabled() {
        super.enabled();
        this.condition = this.makeConditions(this.element, 1);
    }

    public void disabled() {
        this.condition = null;
        super.disabled();
    }

    @Nonnull
    public String getLogoModuleKey() {
        return this.logoModuleKey;
    }

    @Nonnull
    public String getLogoFile() {
        return this.logoFile;
    }

    @Nullable
    public String getDocumentationUrl() {
        return this.helpUrls.getUrl(this.key).getUrl();
    }

    @Nonnull
    public String getSupportedVersions() {
        return this.getI18nBean().getText(StringUtils.defaultString((String)this.supportedVersions));
    }

    public boolean isNonAdmin() {
        return this.isNonAdmin;
    }

    @Nullable
    public String getDescription() {
        return this.description == null ? null : this.getI18nBean().getText(this.description);
    }

    public int getWeight() {
        return this.weight;
    }

    protected Condition makeConditions(Element element, int type) throws PluginParseException {
        return this.conditionElementParser.makeConditions(this.plugin, element, type);
    }

    public String getOnboardingPanelKey() {
        return this.onboardingPanelKey;
    }
}

