/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.exports.transform;

import com.atlassian.jira.plugins.importer.exports.transform.UserTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="default-user")
public class DefaultUserTransformer
implements UserTransformer {
    private final UserUtil userUtil;

    @Autowired
    public DefaultUserTransformer(@ComponentImport UserUtil userUtil) {
        this.userUtil = userUtil;
    }

    public ExternalUser apply(String username) {
        if (username == null) {
            return null;
        }
        ApplicationUser user = this.userUtil.getUserByName(username);
        if (user == null) {
            return null;
        }
        ExternalUser externalUser = new ExternalUser(user.getName(), user.getDisplayName(), user.getEmailAddress());
        externalUser.setGroups(this.userUtil.getGroupNamesForUser(user.getName()));
        externalUser.setActive(user.isActive());
        return externalUser;
    }
}

