/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.exports;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.util.FieldableDocumentHitCollector;
import com.atlassian.jira.plugins.importer.exports.IssuesExporter;
import com.atlassian.jira.plugins.importer.exports.transform.ExportTransformerFactory;
import com.atlassian.jira.plugins.importer.exports.transform.IssueTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.search.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
class IssuesExporterImpl
implements IssuesExporter {
    private static final Logger log = LoggerFactory.getLogger(IssuesExporterImpl.class);
    private final IssueManager issueManager;
    private final ExportTransformerFactory exportTransformerFactory;
    private final ProjectManager projectManager;
    private final SearchProvider searchProvider;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public IssuesExporterImpl(IssueManager issueManager, @Qualifier(value="default-factory") ExportTransformerFactory exportTransformerFactory, ProjectManager projectManager, SearchProvider searchProvider, JiraAuthenticationContext authenticationContext) {
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.searchProvider = searchProvider;
        this.authenticationContext = authenticationContext;
        this.exportTransformerFactory = exportTransformerFactory;
    }

    @Override
    public SampleData exportIssues(Iterable<Long> issueIds) {
        return this.exportIssues(issueIds, this.exportTransformerFactory);
    }

    @Override
    public Optional<SampleData> exportIssues(SearchRequest searchRequest) {
        return this.exportIssues(searchRequest, this.exportTransformerFactory);
    }

    @Override
    public Optional<SampleData> exportIssues(SearchRequest searchRequest, ExportTransformerFactory factory) {
        IssueIdHitCollector issueIdHitCollector = new IssueIdHitCollector();
        try {
            this.searchProvider.searchAndSort(searchRequest != null ? searchRequest.getQuery() : null, this.authenticationContext.getUser(), (Collector)issueIdHitCollector, PagerFilter.getUnlimitedFilter());
        }
        catch (SearchException e) {
            log.warn("Cannot search for selected issues", (Throwable)e);
            return Optional.absent();
        }
        return Optional.of((Object)this.exportIssues(issueIdHitCollector.getIssueIds(), factory));
    }

    @Override
    public SampleData exportIssues(Iterable<Long> issueIds, ExportTransformerFactory factory) {
        ListMultimap projectIssueMap = Multimaps.newListMultimap(new HashMap(), (Supplier)new Supplier<List<ExternalIssue>>(){

            public List<ExternalIssue> get() {
                return Lists.newArrayList();
            }
        });
        for (Long issueId : issueIds) {
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            ExternalIssue externalIssue = (ExternalIssue)factory.getIssueTransformer().apply(issue);
            projectIssueMap.put((Object)issue.getProjectId(), (Object)externalIssue);
        }
        HashSet projects = Sets.newHashSet();
        HashSet requiredUsers = Sets.newHashSet();
        for (Long projectId : projectIssueMap.keySet()) {
            Project project = this.projectManager.getProjectObj(projectId);
            ExternalProject externalProject = (ExternalProject)factory.getProjectTransformer().apply(project);
            List projectIssues = projectIssueMap.get((Object)projectId);
            externalProject.setIssues(projectIssues);
            projects.add(externalProject);
            ImmutableSet issuesUsers = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)projectIssues, (Function)new IssueRequiredUsers(factory.getIssueTransformer()))), (Predicate)Predicates.notNull()));
            requiredUsers.addAll(factory.getProjectTransformer().getRequiredUsers(externalProject));
            requiredUsers.addAll(issuesUsers);
        }
        return new SampleData(null, projects, (Set<ExternalUser>)ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)requiredUsers, (Function)factory.getUserTransformer()), (Predicate)Predicates.notNull())));
    }

    private static class IssueIdHitCollector
    extends FieldableDocumentHitCollector {
        private final Set<Long> issueIds = new LinkedHashSet<Long>(500);
        private final FieldSelector fieldSelector = new FieldSelector(){

            public FieldSelectorResult accept(String fieldName) {
                return fieldName.equals("issue_id") ? FieldSelectorResult.LOAD_AND_BREAK : FieldSelectorResult.NO_LOAD;
            }
        };

        protected FieldSelector getFieldSelector() {
            return this.fieldSelector;
        }

        public void collect(Document document) {
            String issueId = document.get("issue_id");
            this.issueIds.add(Long.valueOf(issueId));
        }

        public Set<Long> getIssueIds() {
            return this.issueIds;
        }
    }

    private static class IssueRequiredUsers
    implements Function<ExternalIssue, Iterable<String>> {
        private final IssueTransformer issueTransformer;

        private IssueRequiredUsers(IssueTransformer issueTransformer) {
            this.issueTransformer = issueTransformer;
        }

        public Iterable<String> apply(ExternalIssue input) {
            return this.issueTransformer.getRequiredUsers(input);
        }
    }
}

