/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.demo;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.plugins.importer.analytics.DemoDataImportFinishedEventFactory;
import com.atlassian.jira.plugins.importer.analytics.DemoDataImportFinishedEventFactoryImpl;
import com.atlassian.jira.plugins.importer.analytics.DemoDataImportStartedEvent;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.compatibility.DemoProjectsAccessor;
import com.atlassian.jira.plugins.importer.demo.DemoDataImportService;
import com.atlassian.jira.plugins.importer.demo.DemoDataProjectInfoBean;
import com.atlassian.jira.plugins.importer.demo.DemoDataProjectInfoBeanBuilder;
import com.atlassian.jira.plugins.importer.demo.DemoDataProjectInfoBeanConverter;
import com.atlassian.jira.plugins.importer.external.ExternalException;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ConsoleImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterOptions;
import com.atlassian.jira.plugins.importer.managers.CreateProjectManager;
import com.atlassian.jira.plugins.importer.rest.DemoDataResponse;
import com.atlassian.jira.plugins.importer.sample.AttachmentsProvider;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.plugins.importer.sample.SampleDataImporter2;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DemoDataImportServiceImpl
implements DemoDataImportService {
    private static final Logger log = LoggerFactory.getLogger(DemoDataImportServiceImpl.class);
    private final EventPublisher eventPublisher;
    private final SampleDataImporter2 sampleDataImporter;
    private final CompatibilityBridgeUtils compatibilityUtil;
    private final DemoDataProjectInfoBeanConverter beanConverter;
    private final ProjectManager projectManager;
    private final ProjectService projectService;
    private final CreateProjectManager createProjectManager;
    private final JiraAuthenticationContext authenticationContext;
    private final DemoDataImportFinishedEventFactory demoDataImportFinishedEventFactory;

    @Autowired
    public DemoDataImportServiceImpl(@ComponentImport ProjectManager projectManager, @ComponentImport ProjectService projectService, @ComponentImport JiraAuthenticationContext authenticationContext, EventPublisher eventPublisher, SampleDataImporter2 sampleDataImporter, CompatibilityBridgeUtils compatibilityUtil, DemoDataProjectInfoBeanConverter beanConverter, CreateProjectManager createProjectManager) {
        this.eventPublisher = eventPublisher;
        this.sampleDataImporter = sampleDataImporter;
        this.projectManager = projectManager;
        this.projectService = projectService;
        this.compatibilityUtil = compatibilityUtil;
        this.beanConverter = beanConverter;
        this.createProjectManager = createProjectManager;
        this.authenticationContext = authenticationContext;
        this.demoDataImportFinishedEventFactory = new DemoDataImportFinishedEventFactoryImpl(this.authenticationContext, this.projectManager, this.projectService, this.compatibilityUtil);
    }

    @Override
    public ServiceOutcome<DemoDataResponse> createDemoDataProject(String projectKey, String projectName, String projectLead, String demoDataKey) {
        Option<DemoProjectsAccessor> demoProjectsAccessor = this.compatibilityUtil.getDemoProjectsAccessor();
        if (demoProjectsAccessor.isEmpty()) {
            return ServiceOutcomeImpl.error((String)"This JIRA is not able to create demo projects");
        }
        Option demoProjectOption = ((DemoProjectsAccessor)demoProjectsAccessor.get()).getDemoProject(demoDataKey);
        if (demoProjectOption.isEmpty()) {
            return ServiceOutcomeImpl.error((String)"Demo project type is not available");
        }
        DemoProjectsAccessor.DemoProject demoProject = (DemoProjectsAccessor.DemoProject)demoProjectOption.get();
        Either<ServiceOutcome<Void>, String> demoData = this.readData(demoProject.getDemoData());
        if (demoData.isLeft()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)((ServiceOutcome)demoData.left().get()));
        }
        DemoDataProjectInfoBean bean = new DemoDataProjectInfoBeanBuilder().setProjectKey(projectKey).setProjectName(projectName).setProjectLead(projectLead).setProjectTemplate((Option<String>)demoProject.getProjectTemplate()).setProjectType((Option<String>)demoProject.getProjectType()).createDemoDataProjectInfoBean();
        this.eventPublisher.publish((Object)new DemoDataImportStartedEvent(demoDataKey));
        ServiceOutcome<DemoDataResponse> demoDataResponseServiceOutcome = this.importDemoProject(bean, (String)demoData.right().get());
        if (demoDataResponseServiceOutcome.isValid()) {
            this.eventPublisher.publish((Object)this.demoDataImportFinishedEventFactory.getDemoDataImportFinishedEvent(demoDataKey, demoProject, (DemoDataResponse)demoDataResponseServiceOutcome.get()));
        }
        return demoDataResponseServiceOutcome;
    }

    private ServiceOutcome<DemoDataResponse> importDemoProject(DemoDataProjectInfoBean projectInfoBean, String demoData) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Map<String, Object> parameters = this.beanConverter.toVelocityParameters(projectInfoBean);
        SampleData sampleData = this.sampleDataImporter.parseSampleData(demoData, parameters);
        ServiceOutcome<Void> projectCreationResult = this.createProjects(sampleData, projectInfoBean);
        if (!projectCreationResult.isValid()) {
            return ServiceOutcomeImpl.error(projectCreationResult);
        }
        ImporterOptions options = new ImporterOptions.Builder().canAlterCustomFieldContext(false).canCreateCustomFields(false).build();
        this.sampleDataImporter.createSampleData(demoData, parameters, null, new Base64AttachmentsProvider(), null, options, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)errorCollection);
        }
        Project project = this.projectManager.getProjectByCurrentKeyIgnoreCase(projectInfoBean.getProjectKey());
        if (project == null) {
            return ServiceOutcomeImpl.error((String)"This Demo Data has not created any project");
        }
        return ServiceOutcomeImpl.ok((Object)new DemoDataResponse(this.getProjectUrl(projectInfoBean.getProjectKey()), project.getId(), projectInfoBean.getProjectKey(), projectInfoBean.getProjectName()));
    }

    private ServiceOutcome<Void> createProjects(SampleData sampleData, DemoDataProjectInfoBean projectInfoBean) {
        Set<ExternalProject> projects = sampleData.getProjects();
        for (ExternalProject project : projects) {
            ProjectService.CreateProjectValidationResult createProjectValidationResult;
            if (StringUtils.isBlank((CharSequence)project.getType()) && projectInfoBean.getProjectType().isDefined()) {
                project.setType((String)projectInfoBean.getProjectType().get());
            }
            if (StringUtils.isBlank((CharSequence)project.getTemplate()) && projectInfoBean.getProjectTemplate().isDefined()) {
                project.setTemplate((String)projectInfoBean.getProjectTemplate().get());
            }
            if ((createProjectValidationResult = this.compatibilityUtil.validateCreateProject(this.authenticationContext.getUser(), project.getName(), project.getKey(), project.getDescription(), project.getLead(), project.getUrl(), project.getAssigneeType(), project.getType(), project.getTemplate())).isValid()) continue;
            return ServiceOutcomeImpl.from((ErrorCollection)createProjectValidationResult.getErrorCollection());
        }
        for (ExternalProject project : projects) {
            try {
                this.createProjectManager.createProject(this.authenticationContext.getUser(), project, new ConsoleImportLogger());
            }
            catch (ExternalException e) {
                log.warn("Cannot create project", (Throwable)((Object)e));
                ServiceOutcomeImpl.error((String)"Cannot create project, check log for details");
            }
        }
        return ServiceOutcomeImpl.ok(null);
    }

    @Override
    public ServiceOutcome<DemoDataResponse> createDemoDataProject(String projectKey, String projectName, String projectLead, InputStream json) {
        String jsonData;
        try {
            jsonData = IOUtils.toString((InputStream)json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DemoDataProjectInfoBean bean = new DemoDataProjectInfoBeanBuilder().setProjectKey(projectKey).setProjectName(projectName).setProjectLead(projectLead).createDemoDataProjectInfoBean();
        return this.importDemoProject(bean, jsonData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Either<ServiceOutcome<Void>, String> readData(URL url) {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            Either either = Either.right((Object)IOUtils.toString((InputStream)inputStream));
            return either;
        }
        catch (IOException e) {
            String errorMessage = "Cannot create Demo Data " + e.getMessage();
            ServiceOutcomeImpl error = ServiceOutcomeImpl.error((String)errorMessage);
            log.warn(errorMessage, (Throwable)e);
            Either either = Either.left((Object)error);
            return either;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private String getProjectUrl(String projectKey) {
        return String.format("/projects/%s", projectKey);
    }

    private final class Base64AttachmentsProvider
    implements AttachmentsProvider {
        private Base64AttachmentsProvider() {
        }

        @Override
        @Nonnull
        public File getAttachmentForIssue(ExternalIssue externalIssue, String name, ImportLogger log) {
            File attachmentFile;
            ExternalAttachment attachment = this.getAttachment(externalIssue, name);
            if (StringUtils.isEmpty((CharSequence)attachment.getData())) {
                throw new IllegalArgumentException("Attachment doesn't have Base64 data");
            }
            byte[] bytes = Base64.decodeBase64((String)attachment.getData());
            FileOutputStream outputStream = null;
            try {
                attachmentFile = File.createTempFile("Demo-data-import-file", ".tmp");
                outputStream = new FileOutputStream(attachmentFile);
                IOUtils.write((byte[])bytes, (OutputStream)outputStream);
            }
            catch (IOException e) {
                try {
                    String message = "Cannot save attachment " + name;
                    log.warn(message, e);
                    throw new RuntimeException(message, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            return attachmentFile;
        }

        private ExternalAttachment getAttachment(ExternalIssue externalIssue, final String name) {
            return (ExternalAttachment)Iterables.getOnlyElement((Iterable)Iterables.filter(externalIssue.getAttachments(), (Predicate)new Predicate<ExternalAttachment>(){

                public boolean apply(ExternalAttachment input) {
                    return name.equals(input.getName());
                }
            }));
        }
    }
}

